package net.wicp.tams.component.components;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PersistenceConstants;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.common.annotation.TamsBean;
import net.wicp.tams.common.annotation.TamsCol;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.IQueryAssetInfo;
import net.wicp.tams.common.beans.QueryAssetInfo;
import net.wicp.tams.common.callback.ICallBack;
import net.wicp.tams.common.callback.ICount;
import net.wicp.tams.common.constant.PageElement;
import net.wicp.tams.common.constant.PageElementOpt;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.assistbean.HideAssetBean;
import net.wicp.tams.component.assistbean.QueryAssetBean;
import net.wicp.tams.component.tools.TapestryAssist;

/***
 * 低代码用 EVENT_QueryAlisConvert事件用于用户定定义别名的转换器，如combobox的地址查询需要租户信息
 * 
 * @author Andy.zhou
 *
 */
@Events({ SymbolConstantsCus.EVENT_QueryAlisConvert, SymbolConstantsCus.EVENT_AnnotationContext })
public class LayoutQuery {

	@Inject
	protected ComponentResources resources;

	@Inject
	protected Request request;

	@Inject
	protected RequestGlobals requestGlobals;

	@Inject
	private ServletContext servletContext;

	/***
	 * 是否需要新增按钮
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean canAdd;

	public boolean getCanAdd() {// 如果传过来的参数含有id，表示查询范围限定了一条记录，也就是只能修改
		return po == null || !po.containsKey("id");// TODO id为主键，写死，后面为灵活需要修改
	}

	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean canupdate;
	/***
	 * 是否能删除
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean canDel;

	/***
	 * 新增时要做的初始化，可以返回false阻止弹出新增框
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String initAddHandle;

	/***
	 * 修改时要做的初始化
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String initSaveHandle;

	/***
	 * 保存前提交的用户检查
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String saveCheckHandle;

	// query的查询handle
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String selectHandle;

	@Inject
	@Property
	private Block renderblock;

	/***
	 * 已在tamsbean中定义并处理了
	 */
//	@Parameter(required = false, value = "width:500px;height:400px;padding:10px;visibility:hidden;", defaultPrefix = BindingConstants.LITERAL)
//	private String dialogStyle;

	/***
	 * 定义查询按钮
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property(read = true, write = false)
	private JSONArray queryButs;
	// queryButs循环用的变量
	@Property
	private JSONObject queryBut;

	// 得到要调用的js函数
	public String getClickFunction() {
		String clickfunctionname = StringUtil
				.trimSpace(queryBut.containsKey("click") ? queryBut.getString("click") : "");
		String retstr = StringUtil.hasNull(clickfunctionname, getButId() + "Do");
		return retstr;
	}

	public String getButId() {
		return StringUtil.trimSpace(queryBut.getString("id"));
	}

	public String getDialogId() {
		return queryBut.containsKey("dialog") ? StringUtil.trimSpace(queryBut.getString("dialog")) : "";
	}

	public String getNeedCheckRow() {
		String checkRow = queryBut.containsKey("checkRow") ? String.valueOf(queryBut.getBoolean("checkRow")) : "true";
		return checkRow;
	}

	public String getMenuButUrl() {
		return queryBut.containsKey("url") ? StringUtil.trimSpace(queryBut.getString("url")) : "";
	}

	public String getConfirmTitle() {
		return queryBut.containsKey("confirm") ? StringUtil.trimSpace(queryBut.getString("confirm")) : "是否执行此操作？";
	}

	/***
	 * 得到页面的注解类
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public TamsBean getTamsBean() {
		TamsBean annotation = (TamsBean) getTClass().getAnnotation(TamsBean.class);
		return annotation;
	}

	private QueryAssetInfo queryAssetInfo;

	@SuppressWarnings({ "unchecked" })
	public String getCols() {
		// 定义用户自己的转换器
		CaptureResultCallback<IQueryAssetInfo> callback = new CaptureResultCallback<IQueryAssetInfo>();
		resources.triggerEvent(SymbolConstantsCus.EVENT_QueryAlisConvert, new Object[] {}, callback);
		IQueryAssetInfo alisQueryAssetInfo = callback.getResult();
		this.queryAssetInfo = EasyUiAssist.getQueryAssetInfo(getTClass(), alisQueryAssetInfo,getAnnotationContext());
		return this.queryAssetInfo.getGridTitleCols();
	}

	/**
	 * 得到注解使用的，用于替换注解参数的内容
	 * 
	 * @return
	 */
	private Map<String, String> getAnnotationContext() {
		// 定义用户自己的转换器
		CaptureResultCallback<ICallBack<Map<String, String>>> callback = new CaptureResultCallback<ICallBack<Map<String, String>>>();
		resources.triggerEvent(SymbolConstantsCus.EVENT_AnnotationContext, new Object[] {}, callback);
		ICallBack<Map<String, String>> result = callback.getResult();
		return result==null?new HashMap<String, String>():result.getObj();
	}

	public String getDefaultValueMap() {
		com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(
				this.queryAssetInfo.getFieldDefaultValueMap());
		return jsonObject.toJSONString();
	}

	@SuppressWarnings({ "rawtypes" })
	private Class getTClass() {
		// .getPage().getClass()有空指针问题
		Class classz = (Class) ((ParameterizedType) (resources.getContainer().getClass()).getGenericSuperclass())
				.getActualTypeArguments()[0];
		return classz;
	}

//	public String getUrl() {
//		TamsBean tamsBean = getTamsBean();
//		String retUrl = tamsBean == null ? "" : tamsBean.url();
//		if (StringUtil.isNull(retUrl)) {
//			// 页面所在的类名
//			String name = resources.getContainer().getClass().getName();
//			String initParameter = servletContext.getInitParameter("tapestry.app-package");
//			retUrl = name.replace(initParameter + ".pages", "").replace(".", "/");
//		}
//		return retUrl;
//	}

	public String getSaveUrl() {
		TamsBean tamsBean = getTamsBean();
		String retUrl = tamsBean == null ? "" : tamsBean.urlSave();
		return TapestryAssist.urlBean(servletContext, resources.getContainer().getClass(), getTamsBean(), retUrl,
				"save", getAnnotationContext());
	}

	public String getQueryUrl() {
		TamsBean tamsBean = getTamsBean();
		String retUrl = tamsBean == null ? "" : tamsBean.urlQuery();
		return TapestryAssist.urlBean(servletContext, resources.getContainer().getClass(), getTamsBean(), retUrl,
				"query", getAnnotationContext());
	}

	public String getDelUrl() {
		TamsBean tamsBean = getTamsBean();
		String retUrl = tamsBean == null ? "" : tamsBean.urlDel();
		return TapestryAssist.urlBean(servletContext, resources.getContainer().getClass(), getTamsBean(), retUrl, "del",
				getAnnotationContext());
	}

	public String getUrl() {
		return TapestryAssist.urlBean(servletContext, resources.getContainer().getClass(), getTamsBean(), null, null,
				getAnnotationContext());
	}

	@Property
	private List<QueryAssetBean> queryItemList;

	@Property
	private QueryAssetBean queryItem;

	public String getTdClass() {
		return this.queryItem.isQuery() ? "frame_table_list_4_righttext" : "frame_table_list_2_righttext";
	}

	public int getPageEleWith() {
		int num = this.queryItem.getColspan() / 2 + 1;
		int lablenum = (num - 1) * 145;
		return this.queryItem.isQuery() ? 120 * num + lablenum : 250 * num + lablenum;
	}

	// 得到页面元素的id
	public String getPageEleId() {
		return String.format("%s_%s", this.queryItem.getColName(), this.queryItem.isQuery() ? "q" : "s");
	}

	// 得到级联的父元素id值
	public String getParentId() {
		Map<PageElementOpt, String> pageElementOpt = this.queryItem.getPageElementOpt();
		String parentColName = pageElementOpt.get(PageElementOpt.parent);
		return StringUtil.isNull(parentColName) ? ""
				: String.format("%s_%s", parentColName, this.queryItem.isQuery() ? "q" : "s");
	}

	// 判断当前的页面元素是否与指定的页面元素相等
	public boolean equal(String pageElementstr) {
		return this.queryItem.getPageElement() == PageElement.valueOf(pageElementstr);
	}

	public String pageElementOpt(PageElementOpt key) {
		Map<PageElementOpt, String> pageElementOpt = this.queryItem.getPageElementOpt();
		String retstr = pageElementOpt.containsKey(key) ? pageElementOpt.get(key)
				: (StringUtil.isNull(key.getDefaultValue()) ? null : key.getDefaultValue());

//		if(key==PageElementOpt.url) {//如果是地址需要替换${}对应的参数
//			retstr=TapestryAssist.urlField(servletContext, resources.getContainer().getClass(), retstr, context);
//		}
		if (StringUtil.isNotNull(retstr) && retstr.contains("$")) {
			Map<String, String> context = getAnnotationContext();
			if (MapUtils.isNotEmpty(context)) {
				for (String contextKey : context.keySet()) {
					retstr = retstr.replace(String.format("${%s}", contextKey), context.get(contextKey));
				}
			}
		}
		return retstr;
	}

	@SuppressWarnings("unchecked")
	protected Pair<List<Field>, List<Field>> querySaveInfo = EasyUiAssist.getQuerySaveInfo(getTClass());

	public List<List<QueryAssetBean>> getQueryItems() {
		return queryItemsCommon(true);
	}

	public List<List<QueryAssetBean>> getSaveItems() {
		return queryItemsCommon(false);
	}

	/***
	 * 按顺序
	 * 
	 * @param numPerRow
	 * @return
	 */
	private List<List<QueryAssetBean>> queryItemsCommon(boolean isQuery) {
		List<Field> collist = isQuery ? querySaveInfo.getLeft() : querySaveInfo.getRight();
		// 转化为最终对象
		List<QueryAssetBean> alllist = new ArrayList<QueryAssetBean>();
		for (Field ele : collist) {
			QueryAssetBean temp = new QueryAssetBean();

			TamsCol tamsCol = ele.getAnnotation(TamsCol.class);
			temp.setColLab(tamsCol.value());
			temp.setQuery(isQuery);
			if (!isQuery) {
				temp.setRequired(tamsCol.save() > 0 ? "true" : "false");
				// .setTdClass("frame_table_list_2_righttext");
			} else {
				temp.setRequired("false");
				// temp.setTdClass("frame_table_list_4_righttext");
			}
			String idStr = String.format("%s_%s", ele.getName(), isQuery ? "q" : "s");
			temp.setColName(ele.getName());
			temp.setFieldId(idStr);
			PageElement pageElement = tamsCol.pageElement();
			Map<PageElementOpt, String> findOpt = pageElement.findOpt(tamsCol);
			temp.setPageElement(pageElement);
			temp.setPageElementOpt(findOpt);
			temp.setColspan(tamsCol.colspan());
			alllist.add(temp);
		}
		// 分隔并补齐
		int numPerRow = isQuery ? 4 : 2;
		List<List<QueryAssetBean>> retlist = CollectionUtil.splitList(QueryAssetBean.class, alllist, numPerRow,
				new ICount<QueryAssetBean>() {
					@Override
					public int countObj(QueryAssetBean obj) {
						return obj.getColspan();
					}
				}, true);
		return retlist;
	}

	private List<HideAssetBean> listHideBean(boolean isQuery) {
		List<HideAssetBean> retlist = new ArrayList<HideAssetBean>();
		if (po == null || CollectionUtils.isEmpty(po.keys())) {
			return retlist;
		}
		List<Field> defFields = isQuery ? querySaveInfo.getLeft() : querySaveInfo.getRight();
		List<String> defFieldNames = new ArrayList<String>();
		for (Field defField : defFields) {
			defFieldNames.add(defField.getName());
		}
		for (String key : po.keys()) {
			if (StringUtil.isNotNull(po.getString(key)) && !defFieldNames.contains(key)) {// 需要隐藏
				HideAssetBean temp = new HideAssetBean();
				String idStr = String.format("%s_%s", key, isQuery ? "q" : "s");
				temp.setFieldName(key);
				temp.setFieldId(idStr);
				temp.setValue(po.getString(key));
				retlist.add(temp);
			}
		}
		return retlist;
	}

	public List<HideAssetBean> getQueryHideItems() {
		return listHideBean(true);
	}

	public List<HideAssetBean> getSaveHideItems() {
		return listHideBean(false);
	}

	/***
	 * 得到保存列po的字段
	 * 
	 * @return
	 */
	private List<HideAssetBean> commonPoFields(boolean isQuery) {
		List<HideAssetBean> retlist = new ArrayList<HideAssetBean>();
		if (po == null || CollectionUtils.isEmpty(po.keys())) {
			return retlist;
		}
		List<Field> defFields = isQuery ? querySaveInfo.getLeft() : querySaveInfo.getRight();
		for (String key : po.keys()) {
			if (StringUtil.isNotNull(po.getString(key))) {// 已传入的参数
				Field selField = null;
				for (Field defField : defFields) {
					if (defField.getName().equals(key)) {
						selField = defField;
						break;
					}
				}
				if (selField != null) {
					TamsCol tamsCol = selField.getAnnotation(TamsCol.class);
					HideAssetBean temp = new HideAssetBean();
					temp.setFieldName(key);
					temp.setValue(po.getString(key));
					temp.setPageElement(tamsCol.pageElement());
					retlist.add(temp);
				}
			}
		}
		return retlist;
	}

	public List<HideAssetBean> getSavePoFields() {
		return commonPoFields(false);
	}

	public List<HideAssetBean> getQueryPoFields() {
		return commonPoFields(true);
	}

	public List<Pair<String, String[]>> getTableToColumns() {
		return new ArrayList<Pair<String, String[]>>();
	}

	@Property
	private HideAssetBean hideAssetBean;

	// 页面需要得到默认值
	@Persist(PersistenceConstants.SESSION)
	@Property
	private JSONObject po;

	// 是否只读
	public boolean getColReadOnly() {
		if (po.containsKey(queryItem.getColName()) && StringUtil.isNotNull(po.getString(queryItem.getColName()))) {
			return true;
		} else {
			return false;
		}
	}

	@SuppressWarnings("unchecked")
	@BeforeRenderTemplate
	private void initRecord() {
		Object beanFromPage = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		String jsonString = com.alibaba.fastjson.JSONObject.toJSONString(beanFromPage);
		this.po = new JSONObject(jsonString);
	}

}
