/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.response;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.wicp.tams.common.apiext.IOUtil;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.http.services.Response;

public class FileStreamResponse
implements StreamResponse {
    private final String fileName;
    private final byte[] byteAry;

    public FileStreamResponse(File file, String fileName) throws IOException {
        this(new FileInputStream(file), fileName);
    }

    public FileStreamResponse(File file) throws IOException {
        this(file, file.getName());
    }

    public FileStreamResponse(InputStream inputStream, String fileName) throws IOException {
        byte[] slurpbyte = IOUtil.slurpbyte((InputStream)inputStream);
        inputStream.close();
        this.fileName = fileName;
        this.byteAry = slurpbyte;
    }

    public FileStreamResponse(InputStream inputStream) throws IOException {
        this(inputStream, "\u4e0b\u8f7d\u6587\u4ef6");
    }

    public FileStreamResponse(byte[] byteAry, String fileName) {
        this.fileName = fileName;
        this.byteAry = byteAry;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.byteAry);
    }

    public void prepareResponse(Response response) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + this.fileName + "\"");
    }
}

