/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.components;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.component.assistbean.FilesBean;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.tools.TapestryAssist;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class Upload {
    public static final String prefix = "rjzjhuploadfield";
    public static final String prefix_exit = "rjzjhexistfield";
    public static final String fixfieldname = "__uploadname__";
    @Inject
    @Path(value="${path.comassets}/images/add.png")
    @Property
    private Asset addImg;
    @Inject
    @Path(value="${path.comassets}/images/del.png")
    @Property
    private Asset delImg;
    @InjectService(value="locales")
    protected ISupportedLocales supportedLocales;
    @Inject
    protected JavaScriptSupport support;
    @Inject
    protected ComponentResources resources;
    @Inject
    protected Messages messages;
    @Parameter(defaultPrefix="literal")
    private String id;
    @Parameter(defaultPrefix="literal")
    private String name;
    @Environmental
    protected JavaScriptSupport javaScriptSupport;
    @Inject
    private AssetSource assetSource;
    @Parameter(value="false", defaultPrefix="literal")
    @Property
    private boolean multi;
    @Parameter(defaultPrefix="literal")
    private String initfile;
    @Property
    private FilesBean initFile = new FilesBean();
    @Property
    private int index;
    @Inject
    @Symbol(value="path.file.upload.dir")
    private String defaultUploadDir;
    @Parameter(defaultPrefix="literal")
    @Property
    private String uploadDir = PathType.getPath((String)this.defaultUploadDir);

    public String getFixfieldname() {
        return fixfieldname;
    }

    public String getFiletag() {
        return prefix;
    }

    public FilesBean[] getInitFiles() {
        if (this.resources.isBound("initfile") && StringUtil.isNotNull((Object)this.initfile)) {
            String[] fileStrs = this.initfile.split(",");
            FilesBean[] rets = new FilesBean[fileStrs.length];
            for (int i = 0; i < fileStrs.length; ++i) {
                FilesBean temp = new FilesBean();
                temp.setFileName(fileStrs[i]);
                temp.setPath(IOUtil.mergeFolderAndFilePath((String)this.uploadDir, (String[])new String[]{fileStrs[i]}));
                temp.setDownLink(this.getUploadFileLink(fileStrs[i]).toURI());
                rets[i] = temp;
            }
            return rets;
        }
        return new FilesBean[0];
    }

    public StreamResponse onUploadFile(String filePath) {
        return TapestryAssist.getFileStreamResponse(this.uploadDir, filePath);
    }

    public Link getUploadFileLink(String filePath) {
        return this.resources.createEventLink("uploadFile", new Object[]{filePath});
    }

    public String getUploadFileUrl() {
        String retcurl = this.resources.createEventLink("uploadFile", new Object[0]).toURI();
        return retcurl;
    }

    public String getInitFileId() {
        return this.getId() + this.index;
    }

    @AfterRenderTemplate
    void afterRenderTemplate() {
        JSONObject spec = new JSONObject();
        spec.put("id", (Object)(this.getId() + "_file"));
        spec.put("delImg", (Object)this.delImg.toString());
        spec.put("prefix", (Object)this.getNameFile());
        this.javaScriptSupport.require("init").invoke("uploadBind").with(new Object[]{spec});
    }

    public String getName() {
        if (this.multi) {
            return prefix;
        }
        if (!this.resources.isBound("name")) {
            return prefix;
        }
        return this.name;
    }

    public String getNameFile() {
        return this.getName() + "_file";
    }

    public String getId() {
        if (!this.resources.isBound("id") && StringUtil.isNull((Object)this.id)) {
            this.id = this.support.allocateClientId(this.resources);
        }
        return this.id;
    }
}

