package net.wicp.tams.component.stack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptAggregationStrategy;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StylesheetLink;

import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.services.ISupportedLocales;

public class CodeMirrorStack implements JavaScriptStack {
	private final Mapper<String, StylesheetLink> pathToStyles;
	private final Mapper<String, Asset> pathToAsset;
	@SuppressWarnings("unused")
	private final ISupportedLocales supportedLocales;
	@SuppressWarnings("unused")
	private final RequestGlobals requestGlobals;

	public CodeMirrorStack(final AssetSource assetSource,
			@Symbol(SymbolConstantsCus.PATH_CODEMIRROR) final String codemirrorpath,
			final ISupportedLocales supportedLocales, final RequestGlobals requestGlobals) {
		this.supportedLocales = supportedLocales;
		this.requestGlobals = requestGlobals;
		this.pathToStyles = new Mapper<String, StylesheetLink>() {
			public StylesheetLink map(String path) {
				return new StylesheetLink(assetSource.getClasspathAsset(codemirrorpath + path));
			}
		};
		this.pathToAsset = new Mapper<String, Asset>() {
			public Asset map(String path) {
				return assetSource.getExpandedAsset(codemirrorpath + path);
			}
		};
	}

	@Override
	public List<Asset> getJavaScriptLibraries() {
		// codemirror.js必填
		// mode/yaml/yaml.js yaml格式
		List<String> jsary = new ArrayList<String>();
//		jsary.add("/lib/codemirror.js");// 必填
//		jsary.add("/mode/yaml/yaml.js");// yaml模式
//		jsary.add("/yaml.min.js");// 操作转换yaml文件为object
//		// 下面是折叠代码
//		jsary.add("/addon/fold/foldcode.js");
//		jsary.add("/addon/fold/foldgutter.js");
//		jsary.add("/addon/fold/brace-fold.js");
//		jsary.add("/addon/fold/comment-fold.js");
//		jsary.add("/addon/fold/xml-fold.js");
		return F.flow(jsary.toArray(new String[jsary.size()])).map(pathToAsset).toList();
	}

	@Override
	public List<StylesheetLink> getStylesheets() {
		List<String> css = new ArrayList<String>();
		css.add("/lib/codemirror.css");
		css.add("/theme/dracula.css");// dracula.css风格
		// 下面是折叠代码
		css.add("/addon/fold/foldgutter.css");
		return F.flow(css.toArray(new String[css.size()])).map(pathToStyles).toList();// icon一定要出现在easyui后面，否则树的图标无效
	}

	@Override
	public List<String> getStacks() {
		return Collections.emptyList();
	}

	@Override
	public List<String> getModules() {
		return Collections.emptyList();
	}

	@Override
	public JavaScriptAggregationStrategy getJavaScriptAggregationStrategy() {
		return JavaScriptAggregationStrategy.DO_NOTHING;
	}

	@Override
	public String getInitialization() {
		return null;
	}

}
