package net.wicp.tams.component.pages;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.util.TextStreamResponse;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import cn.hutool.core.bean.BeanUtil;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.beans.QueryAssetInfo;
import net.wicp.tams.component.tools.TapestryAssist;

/***
 * 只有接入了mybatisplus的项目才能使用
 * 
 * @author Andy
 *
 * @param <T>
 */
public abstract class ParentPageBeanMyBatis<T> extends ParentPageBean<T> {

	////////////////////////////////////////////////////////////// mytatis特有的/////////////////////////////////////////////////////////////////////////////////

	public abstract BaseMapper<T> getBaseMapper();

	public abstract void packageQuery(T t, QueryWrapper<T> queryWrapper);

	public TextStreamResponse onQuery() {
		final T t = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		QueryWrapper<T> queryWrapper = new QueryWrapper<T>();
		this.packageQuery(t, queryWrapper);// 组装查询
		BaseMapper<T> mapper = getBaseMapper();
		Pair<List<T>, Long> query = this.query(mapper, queryWrapper);
		// Pair<List<SysUser>, Long> query = doQuery(t, queryWrapper);
		QueryAssetInfo queryAssetInfo = queryAssetInfo();
		String retstr = EasyUiAssist.getJsonForGridAlias2(query.getLeft(), queryAssetInfo.getConvertTitle(),
				queryAssetInfo.getConvertMap(), query.getRight(), queryAssetInfo.getExcludeFields());
		return TapestryAssist.getTextStreamResponse(retstr);
	}

	/***
	 * mybatis查询封装
	 * 
	 * @param <T>          mybatis的po
	 * @param mapper       mybatis的mapper
	 * @param queryWrapper mybatis的查询封装
	 * @return L：数据，R:数据的总量
	 */
	public <T> Pair<List<T>, Long> query(BaseMapper<T> mapper, QueryWrapper<T> queryWrapper) {
		String needpage = request.getParameter("needpage");
		boolean isPage = StringUtil.isNotNull(needpage) && !Boolean.parseBoolean(needpage) ? false : true;
		List<T> selectList = null;
		long size = 0;
		if (isPage) {// 需要分页，默认
			Page<T> selectPage = mapper.selectPage(ParentPageBeanMyBatis.buildPage(request), queryWrapper);
			selectList = selectPage.getRecords();
			// 观察：没达到分页条件时，total为0，不去调count(*)查询了
			size = selectPage.getTotal() > selectPage.getCurrent() ? selectPage.getTotal() : selectPage.getCurrent();
		} else {
			selectList = mapper.selectList(queryWrapper);
			size = selectList.size();
		}
		return Pair.of(selectList, size);
	}

	/***
	 * 保存或修改对象
	 * 
	 * @param mapper
	 * @param callback
	 * @return
	 */
	public TextStreamResponse saveCommon(BaseMapper<T> mapper, IUpdateObj<T> callback) {
		final T po = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		if (callback != null) {
			callback.doUpdate(po, BeanUtil.getFieldValue(po, "id") == null);
		}
		if (BeanUtil.getFieldValue(po, "id") == null) {
			mapper.insert(po);
		} else {
			ReflectAssist.invokeMothed(mapper, "updateByPrimaryKeySelective", po);
		}
		return TapestryAssist.getTextStreamResponse(Result.getSuc());
	}

	public TextStreamResponse saveCommon(BaseMapper<T> mapper) {
		return saveCommon(mapper, null);
	}

	protected interface IUpdateObj<V> {
		public void doUpdate(V po, boolean isInsert);
	}

	////////////////////////////////////////////////////////// 配合common-jdbc一起使用/////////////////////////////////////////////////////////////////////////////////////////////////////

	public static <T> Page<T> buildPage(Request request) {
		int page = request.getParameterNames().contains("page") ? Integer.parseInt(request.getParameter("page")) : 1;
		int rows = request.getParameterNames().contains("rows") ? Integer.parseInt(request.getParameter("rows")) : 10;
		return new Page<T>(page, rows);
	}

}
