package net.wicp.tams.component.pages;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.util.TextStreamResponse;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.annotation.TamsBean;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.IQueryAssetInfo;
import net.wicp.tams.common.beans.QueryAssetInfo;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.components.Upload;
import net.wicp.tams.component.tools.TapestryAssist;

@Slf4j
public abstract class ParentPageBean<T> extends ParentPage {
	@SuppressWarnings("unchecked")
	public Class<T> getTClass() {
		Class<T> tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}

	/**
	 * 只有一个入口,不能被覆盖
	 * 
	 * 默认的转换器，由注解方式生成。如果没使用注解方式，覆盖这个方法。L:所有列名 M:别名集合，R：转换器
	 * 
	 * @return
	 */
	protected final QueryAssetInfo queryAssetInfo() {
		return EasyUiAssist.getQueryAssetInfo(getTClass(), cusQueryAssetInfo());
	}

	/***
	 * 子类可以覆盖它来 做自己的convert
	 * 
	 * @return
	 */
	@OnEvent(value = SymbolConstantsCus.EVENT_QueryAlisConvert)
	protected IQueryAssetInfo cusQueryAssetInfo() {
		return new IQueryAssetInfo() {

			@SuppressWarnings("rawtypes")
			@Override
			public Map<String, IConvertValue> queryAlisConvert() {
				return new HashMap<String, IConvertValue>();
			}
		};
	};

	protected Pair<List<Field>, List<Field>> querySaveInfo = EasyUiAssist.getQuerySaveInfo(getTClass());

	public String getCols() {
		return queryAssetInfo().getGridTitleCols();
	}

	// 子类可以覆盖,每个页面可以设置自己的文件上传相对路径,默认是上传文件的根路径
	protected String getUploadRelaPath() {
		return "/";
	};

	@Property
	private TamsBean tamsbean = getTClass().getAnnotation(TamsBean.class);

	protected final T t = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);

	@Inject
	@Symbol(SymbolConstantsCus.PATH_FILE_UPLOAD_DIR)
	protected String defaultUploadDir;// 默认的文件上传目录,在service里配置
	
	//得到当前页面的上传目录
	public String getUpladDir() {
		return IOUtil.mergeFolderAndFilePath(defaultUploadDir, getUploadRelaPath());
	}

	public TextStreamResponse onSave() {
		final T saveBean = TapestryAssist.getBeanFromPage(getTClass(), requestGlobals);
		String id = request.getParameter("id");
		// 处理文件上传组件
		String fieldName = request.getParameter(Upload.fixfieldname);
		if (StringUtil.isNotNull(fieldName)) {//
			List<File> saveUploads = req.saveUpload(getUploadRelaPath());
			if (CollectionUtils.isNotEmpty(saveUploads)) {
				try {
					PropertyUtils.setProperty(saveBean, fieldName.substring(0, fieldName.length() - 5),
							IOUtil.mergeFolderAndFilePath(getUploadRelaPath(), saveUploads.get(0).getName()));
				} catch (Exception e) {
					log.error("上传文件时设置文件名属性错误", e);
				}
			}
		}
		// end 处理文件上传组件
		boolean isInsert = false;
		if (StringUtil.isNull(id)) {
			isInsert = true;
		} else {
			isInsert = false;
		}
		try {
			doSave(saveBean, isInsert);
		} catch (Throwable e) {
			log.error("save data error", e);
			return TapestryAssist.getTextStreamResponse(Result.getError(e.getMessage()));
		}
		return TapestryAssist.getTextStreamResponse(Result.getSuc());
	}

	public TextStreamResponse onDel() {
		String id = request.getParameter("id");
		if (StringUtil.isNull(id)) {
			return TapestryAssist.getTextStreamResponse(Result.getSuc("没有拿到id，不能进行删除"));
		}
		try {
			doDel(id);
		} catch (Throwable e) {
			log.error("delete data error", e);
			return TapestryAssist.getTextStreamResponse(Result.getError(e.getMessage()));
		}
		return TapestryAssist.getTextStreamResponse(Result.getSuc());
	}

	public String getUrl() {
		String retUrl = tamsbean.url();
		if (StringUtil.isNull(retUrl)) {
			// 页面所在的类名
			String name = getClass().getName();
			String initParameter = servletContext.getInitParameter("tapestry.app-package");
			retUrl = name.replace(initParameter + ".pages", "").replace(".", "/");
		}
		return retUrl;
	}

	public abstract void doSave(T t, boolean isInsert);

	public abstract void doDel(String id);

}
