package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;

/*****
 * 下拉树表格组件 20210521复制ComboGrid小修改
 * 
 * @author 周俊辉
 * 
 */
@Import(stack = "easyuistack")
public class ComboTreeGrid extends DataGrid {
	/****
	 * 下拉列表panel的宽度
	 */
	@Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
	private int panelWidth;
	/****
	 * 下拉列表panel的高度
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int panelHeight;
	/*****
	 * 是否多选（在Combo组件暂时没用到）
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private boolean multiple;
	/****
	 * 当是多选时返回文本的分隔符（在Combo组件暂时没用到）
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String separator;
	/***
	 * 定义是否可用
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private boolean disabled;
	/***
	 * 定义是否只读
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private boolean readonly;
	/****
	 * 下拉列表是否有像下的箭头
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private boolean hasDownArrow;
	/****
	 * 显示的字段（该属性自1.5.2版开始可用）
	 */
	// @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
	// private String textfield;

	@Parameter(required = false, value = "id", defaultPrefix = BindingConstants.LITERAL)
	private String idfield;

	@Parameter(required = false, value = "text", defaultPrefix = BindingConstants.LITERAL)
	private String treeField;

	/**
	 * 限制输入的值只能是树形表格中的值。
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean limitToGrid;

	/****
	 * 当值改变时触发
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String changeHandle;

	/****
	 * 最后输入字符后的延迟显示列表时间
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int delay;

	@Override
	protected void packSpec(JSONObject spec) {
		super.packSpec(spec);
		spec.put("class", "combotreegrid");
		spec.put("ishtml", false);
		if (resources.isBound("value")) {
			spec.put("value", value);
		}
		JSONObject params = spec.getJSONObject("params");
		params.put("idField", idfield);
		params.put("treeField", treeField);
		if (resources.isBound("limitToGrid"))
			params.put("limitToGrid", limitToGrid);
		if (resources.isBound("width"))
			params.put("width", width);
		if (resources.isBound("height"))
			params.put("height", height);
		if (resources.isBound("panelWidth"))
			params.put("panelWidth", panelWidth);
		if (resources.isBound("panelHeight"))
			params.put("panelHeight", panelHeight);
		if (resources.isBound("multiple"))
			params.put("multiple", multiple);
		if (resources.isBound("separator"))
			params.put("separator", separator);
		if (resources.isBound("disabled"))
			params.put("disabled", disabled);

		if (resources.isBound("readonly"))
			params.put("readonly", readonly);
		if (resources.isBound("hasDownArrow"))
			params.put("hasDownArrow", hasDownArrow);
		if (resources.isBound("delay"))
			params.put("delay", delay);
		// andyzhou 2020-11-02 增加选择
		if (resources.isBound("changeHandle"))
			spec.put("changeHandle", changeHandle);

	}

	@Override
	protected void writeFieldTag(MarkupWriter writer, final JSONObject spec) {
		packSpec(spec);
		writer.element("div", "id", getClientId());// 设置占位符
		javaScriptSupport.require("init").invoke("combotreegrid").with(spec);
	}

}
