package net.wicp.tams.component.assistbean;

import java.util.List;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.fastjson.FastJsonUtil;

public class Echars {
	@SuppressWarnings("rawtypes")
	public static Class[] allClass = new Class[] { Pointer.class, TextStyle.class, LineStyle.class, AxisLine.class,
			AxisTick.class, Detail.class, SplitLine.class, Title.class, DataEle.class, Serie.class, Tooltip.class,
			Toolbox.class, Mark.class, Restore.class, SaveAsImage.class, Feature.class, Option.class };

	@lombok.Data
	@Builder
	public static class Pointer {
		private Integer width;
	}

	@lombok.Data
	@Builder
	public static class TextStyle {
		private String fontWeight;
		private Integer fontSize;
		private String fontStyle;// italic
	}

	@lombok.Data
	@Builder
	public static class LineStyle {
		private String color;// auto
	}

	@lombok.Data
	@Builder
	public static class AxisLine {
		private String length;
		private LineStyle lineStyle;
	}

	@lombok.Data
	@Builder
	public static class AxisTick {
		private String length;
		private LineStyle lineStyle;
	}

	@lombok.Data
	@Builder
	public static class Detail {
		private TextStyle textStyle;
	}

	@lombok.Data
	@Builder
	public static class SplitLine {
		private Integer length;
		private LineStyle lineStyle;
	}

	@lombok.Data
	@Builder
	public static class Title {
		private TextStyle textStyle;
	}

	@Data
	@Builder
	public static class DataEle {
		private Integer value;
		private String name;
	}

	@lombok.Data
	@Builder
	public static class Serie {
		private String name;
		private String type;
		private Integer z;
		private Integer min;
		private Integer max;
		private Integer splitNumber;
		private String radius;
		private AxisLine axisLine;
		private AxisTick axisTick;
		private SplitLine splitLine;
		private Title title;
		private Detail detail;
		private List<DataEle> data;
	}

	@Data
	@Builder
	public static class Tooltip {
		private String formatter;
	}

	@Data
	@Builder
	public static class Toolbox {
		private boolean show;
		private Feature feature;
	}

	@Data
	@Builder
	public static class Mark {
		private boolean show;
	}

	@Data
	@Builder
	public static class Restore {
		private boolean show;
	}

	@Data
	@Builder
	public static class SaveAsImage {
		private boolean show;
	}

	@Data
	@Builder
	public static class Feature {
		private Mark mark;
		private Restore restore;
		private SaveAsImage saveAsImage;
	}

	@Data
	@Builder
	public static class Option {
		private Tooltip tooltip;
		private Toolbox toolbox;
		private List<Serie> series;
	}

	public static String buildOption(Option option) {
		String retstr = FastJsonUtil.toJSONString(option, allClass);
		return retstr;
	}

}
