package net.wicp.tams.component.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.commons.Configuration;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.services.CoercionTuple;
import org.apache.tapestry5.commons.util.StringToEnumCoercion;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.util.TextStreamResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.ContentType;
import net.wicp.tams.common.thread.threadlocal.PerThreadValue;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Slf4j
public abstract class TapestryAssist {
	public static final String[][] specialChar_value = new String[][] { { "\"", "\\\\\"" } };
	private static Logger logger = LoggerFactory.getLogger(TapestryAssist.class);

	/*****
	 * 返回TextStreamResponse
	 *
	 * @param opt
	 * @return
	 */
	public static TextStreamResponse getTextStreamResponse(Result opt) {
		return getTextStreamResponse(opt.retJsonObj().toJSONString());
	}

	/*****
	 * 返回TextStreamResponse
	 *
	 * @param jsonStr json格式的字符串
	 * @return
	 */
	public static TextStreamResponse getTextStreamResponse(String jsonStr) {
		return new TextStreamResponse("text/html", jsonStr);
	}

	/*****
	 * 返回一个空的streamResponse
	 *
	 * @return
	 */
	public static TextStreamResponse getTextStreamResponseEmpty() {
		return new TextStreamResponse("text/html", EasyUiAssist.getJsonForGridEmpty());
	}

	/***
	 * 得到本地文件的流
	 * 
	 * @param rootDir
	 * @param filePath
	 * @return
	 */
	public static StreamResponse getFileStreamResponse(String rootDir, final String filePath) {
		int indexOf = filePath.lastIndexOf(".");
		String suffix = filePath.substring(indexOf);
		return new StreamResponse() {
			public String getContentType() {
				return ContentType.findSuffix(suffix).getValue();
			}
			public InputStream getStream() {
				try {
					String filePathTrue = IOUtil.mergeFolderAndFilePath(rootDir, filePath);
					FileInputStream inputStream = new FileInputStream(new File(filePathTrue));
					return inputStream;
				} catch (FileNotFoundException e) {
					log.error("下载文件失败", e);
					return null;
				}
			}

			public void prepareResponse(Response response) {
				int lastIndexOf = filePath.lastIndexOf("/");
				String filename = filePath.substring(lastIndexOf+1);
				response.setHeader("Content-Disposition", "attachment; filename="+filename);
			}
		};
	}

	/***
	 * 把tapestry的路径转为系统文件的路径,如果不存在相关文件就会抛出异常
	 *
	 * @param assetSource
	 * @param tPath
	 * @return
	 */
	public static String getResPathByTPath(AssetSource assetSource, String tPath) {
		if (assetSource == null || StringUtil.isNull(tPath)) {
			return "";
		}
		Asset asset = assetSource.getExpandedAsset(tPath);
		return asset.getResource().toURL().toString().replace("file:/", "");
	}

	/****
	 * 把JSONArray转成List,页按"index"域排序
	 *
	 * @param arry
	 * @param comp 比较对象
	 * @return
	 */
	public static List<JSONObject> getJSONObjectList(JSONArray arry, CompartorJson comp) {
		List<JSONObject> retObjList = new ArrayList<JSONObject>();
		if (arry == null || arry.length() == 0) {
			return retObjList;
		}
		for (int i = 0; i < arry.length(); i++) {
			JSONObject eleObject = arry.getJSONObject(i);
			retObjList.add(eleObject);
		}
		if (comp != null) {
			Collections.sort(retObjList, comp);
		}
		return retObjList;
	}

	public static List<JSONObject> getJSONObjectList(JSONArray arry) {
		return getJSONObjectList(arry, null);
	}

	/****
	 * 通过key得到国际化信息
	 *
	 * @param messages
	 * @param key
	 * @param param
	 * @return
	 */
	public static String LK(Messages messages, String key, Object... param) {
		if (StringUtil.isNull(key) || !messages.contains(key)) {
			return String.format(messages.get("common.hint.needI18n"), key); // 提示缺少国际化
		}
		return String.format(messages.get(key), param);
	}

	/****
	 * 得到请求的参数，如果是数组则对象是JSONArray,否则是String
	 *
	 * @param request
	 * @return
	 */
	public static JSONObject packParams(Request request, boolean convert) {
		JSONObject retobj = new JSONObject();
		if (request == null) {
			return retobj;
		}
		List<String> keys = request.getParameterNames();
		if (CollectionUtils.isNotEmpty(keys)) {
			for (String key : keys) {
				if (key.endsWith("[]")) {
					String[] objs = request.getParameters(key);
					if (ArrayUtils.isNotEmpty(objs)) {
						JSONArray ary = new JSONArray();
						for (int i = 0; i < objs.length; i++) {
							ary.put(convert ? JSONUtil.convertJsonValue(StringUtil.trimSpace(objs[i]))
									: StringUtil.trimSpace(objs[i]));
						}
						retobj.put(key.replace("[]", ""), ary);
					}
				} else {
					String str = ArrayUtils.isNotEmpty(request.getParameters(key))
							? CollectionUtil.arrayJoin(request.getParameters(key), ",")
							: request.getParameter(key);// 存在如：下拉多选值,奇怪的是：修改前如果选择了一项，request.getParameter(key)不为空，如果修改前没有选择项则为空？
					retobj.put(key, convert ? JSONUtil.convertJsonValue(StringUtil.trimSpace(str))
							: StringUtil.trimSpace(request.getParameter(key)));// 去除前后空格，复制粘贴失误
				}
			}
		}
		return retobj;
	}

	/****
	 * 得到参数的值，如果是数组则只取第一个元素
	 *
	 * @param params
	 * @param name
	 * @return
	 */
	public static String getParam(JSONObject params, String name) {
		if (!params.has(name)) {
			return null;
		}
		Object obj = params.opt(name);
		if (obj == null) {
			return null;
		}
		if (obj instanceof JSONArray) {
			JSONArray temp = (JSONArray) obj;
			return temp.getString(0);
		} else {
			return String.valueOf(obj);
		}
	}

	/***
	 * 得到参数的多值，如果只有一个元素只返回一个元素的JSONArray
	 *
	 * @param params
	 * @param name
	 * @return
	 */
	public static JSONArray getParams(JSONObject params, String name) {
		if (!params.has(name)) {
			return null;
		}
		Object obj = params.opt(name);
		if (obj == null) {
			return null;
		}
		if (obj instanceof JSONArray) {
			JSONArray temp = (JSONArray) obj;
			return temp;
		} else {
			JSONArray temp = new JSONArray(obj);
			return temp;
		}
	}

	public static JSONObject buildSelGroupInit(List<?> allObj, List<String> selIds, String[] aliasTitles,
			Map<String, IConvertValue<String>> convertsMap) {
		JSONObject ret = new JSONObject();
		if (CollectionUtils.isEmpty(allObj)) {
			ret.put("data", new JSONArray());
			ret.put("sel", new JSONArray());
			return ret;
		}
		String dataStr = JSONUtil.getJsonForListAlias(allObj, aliasTitles, convertsMap);
		JSONArray dataary = new JSONArray(dataStr);
		ret.put("data", dataary);
		JSONArray selId = new JSONArray();
		if (CollectionUtils.isNotEmpty(selIds)) {
			for (Object ele : selIds) {// 请用Object,因为有可能是整形传过来
				boolean include = false;
				for (int i = 0; i < dataary.size(); i++) {
					JSONObject obj = dataary.getJSONObject(i);
					if (obj.getString("id").equals(String.valueOf(ele))) {
						include = true;
						break;
					}
				}
				if (include) {
					selId.add(String.valueOf(ele));
				}
			}
		}
		ret.put("sel", selId);
		return ret;
	}

	/***
	 * 把数据转成SelGroup可以识别的数据
	 *
	 * @param allObj
	 * @param selIds
	 * @return
	 */
	public static JSONObject buildSelGroupInit(List<?> allObj, List<String> selIds) {
		return buildSelGroupInit(allObj, selIds, null, null);
	}

	/****
	 * 把请求字段封装到Bean中
	 *
	 * @param clazz
	 * @param request
	 * @param convert 是否转为满足json格式的字符器
	 * @return
	 */
	public static <T> T getBeanFromPage(Class<T> clazz, Request request, boolean convert) {
		JSONObject packParams = packParams(request, convert);
		return getBeanFromPage(clazz, packParams);
	}

	public static <T> T getBeanFromPage(Class<T> clazz, Request request) {
		return getBeanFromPage(clazz, request, true);
	}

	public static <T> T getBeanFromPage(Class<T> clazz, JSONObject packParams) {
		try {
			T retobj = clazz.newInstance();
			if (packParams.length() == 0) {
				return retobj;
			}
			for (String key : packParams.keys()) {
				StringUtil.packObj(retobj, key, packParams.getString(key));
			}
			return retobj;
		} catch (Exception e) {
			throw new IllegalAccessError("request转为业务对象时异常" + e.getMessage());
		}
	}

	public static <T> T getBeanFromPage(Class<T> clazz, RequestGlobals requestGlob) {
		return getBeanFromPage(clazz, requestGlob.getRequest());
	}

	/****
	 * 把请求封装为一个Map
	 * 
	 * @param request
	 * @return
	 */
	public static Map<String, Object> getParameterMap(Request request) {
		List<String> names = request.getParameterNames();
		Map<String, Object> paramsMap = new HashMap<String, Object>();
		StringBuilder sb = new StringBuilder();
		for (String name : names) {
			Object[] values = request.getParameters(name);
			if (values != null) {
				String key = name.replaceAll("\\[\\]", "");
				if (values.length == 1) {
					paramsMap.put(key, values[0]);
				} else {
					paramsMap.put(key, values);
				}
				String v = Arrays.asList(values).toString();
				sb.append("key = ").append(key).append(" , value = ").append(v).append("\r\n");
			}
		}
		logger.debug("The parameters:\r\n" + sb.toString());
		return paramsMap;
	}

	/***
	 * 添加枚举类的转换器,5.6使用
	 * 
	 * @param configuration
	 * @param enumType
	 */
	@SuppressWarnings("rawtypes")
	public static <T extends Enum> void addEnumCoercion(Configuration<CoercionTuple> configuration, Class<T> enumType) {
		configuration.add(CoercionTuple.create(String.class, enumType, StringToEnumCoercion.create(enumType)));
	}

	/***
	 * 添加枚举类的转换器,5.7使用
	 * 
	 * @param <T>
	 * @param configuration
	 * @param enumType
	 */
	@SuppressWarnings("rawtypes")
	public static <T extends Enum> void addEnumCoercion(
			MappedConfiguration<CoercionTuple.Key, CoercionTuple> configuration, Class<T> enumType) {
		CoercionTuple tuple = CoercionTuple.create(String.class, enumType, StringToEnumCoercion.create(enumType));
		configuration.add(tuple.getKey(), tuple);
	}
	
	
	//////////////////////////////////////////////////////////配合common-jdbc一起使用/////////////////////////////////////////////////////////////////////////////////////////////////////
	
	public static <T> Page<T> buildPage(Request request) {
		int page = Integer.parseInt(request.getParameter("page"));
		int rows = Integer.parseInt(request.getParameter("rows"));
		return new Page<T>(page, rows);
	}

}
