package net.wicp.tams.component.services;

import java.io.File;
import java.util.List;

import org.apache.tapestry5.util.TextStreamResponse;

import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.web.PageAssist;

/***
 * 跟web请求相关的工具类
 * 
 * @author andy.zhou
 *
 */
public interface IReq {
	/***
	 * 文件上传工具方法
	 * 
	 * @param uploadRelaPath 上传的文件
	 * @return
	 */
	public List<File> saveUpload(String uploadRelaPath);

	/***
	 * 得到上传文件的UTF-8的编码
	 * 
	 * @return
	 */
	public List<String> uploadFile();


	/***
	 * 文件上传工具方法：上传到默认的文件路径
	 * 
	 * @return
	 */
	public List<File> saveUpload();

	/****
	 * 得到context的文件路径
	 * 
	 * @return
	 */
	public String getContextFilePath();

	/****
	 * 得到context的文件目录
	 * 
	 * @return
	 */
	public File getContextDir();

	/***
	 * 得到默认的文件上传目录
	 * 
	 * @return
	 */
	public File getUploadDir();

	/****
	 * 得到枚举的转换器
	 * 
	 * @param entityClass
	 * @return
	 */
	public IConvertValue<String> getEnumConvert(Class entityClass);

	public PageAssist buildPage();

	/***
	 * 得到成功的回复
	 * 
	 * @return
	 */
	public TextStreamResponse retSuccInfo();

	/***
	 * 得到成功的回复
	 * 
	 * @param sucInfo 成功信息
	 * @return
	 */
	public TextStreamResponse retSuccInfo(String sucInfo);

	/***
	 * 得到错误的返回信息
	 * 
	 * @param errmsg 错误信息
	 * @return
	 */
	public TextStreamResponse retErrorInfo(String errmsg);
}
