package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;

/*****
 * 数字输入框
 * 
 * @author Administrator
 * 
 */
@Import(stack = "easyuistack")
public class NumberBox extends ValidateBox {
	/***
	 * 定义是否可用
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private boolean disabled;

	/***
	 * 最小值
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int min;

	/***
	 * 最大值
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int max;

	/***
	 * 精度
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int precision;

	/****
	 * 整数和小数部分的分隔字符
	 */
	@Parameter(required = false, value = ".", defaultPrefix = BindingConstants.LITERAL)
	private String decimalSeparator;

	/****
	 * 成千上百万的分组分隔符
	 */
	@Parameter(required = false, value = ",", defaultPrefix = BindingConstants.LITERAL)
	private String groupSeparator;

	/****
	 * 前缀
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String prefix;

	/****
	 * 后缀
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String suffix;

	/***
	 * 过滤键盘按下事件，返回true为接受，false拒绝
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String filter;

	/***
	 * 解析一个字符串放到输入框(经测试有问题，放弃此函数)
	 */
	// @Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	// private String parser;

	/***
	 * 格式化数据框里的值，然后显示
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String formatter;

	@Override
	protected void packParms(JSONObject spec) {
		super.packParms(spec);
		spec.put("class", "numberbox");
		spec.put("ishtml", false);
		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("disabled"))
			params.put("disabled", disabled);
		if (resources.isBound("min"))
			params.put("min", min);
		if (resources.isBound("max"))
			params.put("max", max);
		if (resources.isBound("precision") && precision >= 0)// 精度大于0才可以
			params.put("precision", precision);
		if (resources.isBound("decimalSeparator"))
			params.put("decimalSeparator", decimalSeparator);
		if (resources.isBound("groupSeparator"))
			params.put("groupSeparator", groupSeparator);
		if (resources.isBound("prefix"))
			params.put("prefix", prefix);
		if (resources.isBound("suffix"))
			params.put("suffix", suffix);

		if (resources.isBound("filter"))
			spec.put("filter", filter);
		// if (resources.isBound("parser"))
		// spec.put("parser", parser);
		if (resources.isBound("formatter"))
			spec.put("formatter", formatter);

	}

	boolean beforeRenderBody() {
		return false;
	}
}
