package net.wicp.tams.component.components;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;

import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.common.annotation.TamsBean;
import net.wicp.tams.common.annotation.TamsCol;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.IQueryAssetInfo;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.ICount;
import net.wicp.tams.common.constant.PageElement;
import net.wicp.tams.common.constant.PageElementOpt;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.assistbean.QueryAssetBean;

/***
 * 低代码用 EVENT_QueryAlisConvert事件用于用户定定义别名的转换器，如combobox的地址查询需要租户信息
 * 
 * @author Andy.zhou
 *
 */
@Events({ SymbolConstantsCus.EVENT_QueryAlisConvert })
public class LayoutQuery {

	@Inject
	protected ComponentResources resources;

	@Inject
	protected Request request;

	@Inject
	protected RequestGlobals requestGlobals;

	@Inject
	private ServletContext servletContext;

	/***
	 * 新增时要做的初始化，可以返回false阻止弹出新增框
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String initAddHandle;

	/***
	 * 修改时要做的初始化
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String initSaveHandle;

	/***
	 * 保存前提交的用户检查
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String saveCheckHandle;

	// query的查询handle
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String selectHandle;

	@Inject
	@Property
	private Block renderblock;
	
	

	/***
	 * 已在tamsbean中定义并处理了
	 */
//	@Parameter(required = false, value = "width:500px;height:400px;padding:10px;visibility:hidden;", defaultPrefix = BindingConstants.LITERAL)
//	private String dialogStyle;

	/***
	 * 定义查询按钮
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property(read = true, write = false)
	private JSONArray queryButs;
	// queryButs循环用的变量
	@Property
	private JSONObject queryBut;

	// 得到要调用的js函数
	public String getClickFunction() {
		String clickfunctionname = StringUtil
				.trimSpace(queryBut.containsKey("click") ? queryBut.getString("click") : "");
		String retstr = StringUtil.hasNull(clickfunctionname, getButId() + "Do");
		return retstr;
	}

	public String getButId() {
		return StringUtil.trimSpace(queryBut.getString("id"));
	}

	public String getDialogId() {
		return queryBut.containsKey("dialog") ? StringUtil.trimSpace(queryBut.getString("dialog")) : "";
	}

	public String getNeedCheckRow() {
		String checkRow = queryBut.containsKey("checkRow") ? String.valueOf(queryBut.getBoolean("checkRow")) : "true";
		return checkRow;
	}

	public String getMenuButUrl() {
		return queryBut.containsKey("url") ? StringUtil.trimSpace(queryBut.getString("url")) : "";
	}

	public String getConfirmTitle() {
		return queryBut.containsKey("confirm") ? StringUtil.trimSpace(queryBut.getString("confirm")) : "是否执行此操作？";
	}

	/***
	 * 得到页面的注解类
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public TamsBean getTamsBean() {
		TamsBean annotation = (TamsBean) getTClass().getAnnotation(TamsBean.class);
		return annotation;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public String getCols() {
		// 定义用户自己的转换器
		CaptureResultCallback<IQueryAssetInfo> callback = new CaptureResultCallback<IQueryAssetInfo>();
		resources.triggerEvent(SymbolConstantsCus.EVENT_QueryAlisConvert, new Object[] {}, callback);
		IQueryAssetInfo alisQueryAssetInfo = callback.getResult();
		MutableTriple<String, String[], Map<String, IConvertValue>> queryAssetInfo = EasyUiAssist
				.getQueryAssetInfo(getTClass(), alisQueryAssetInfo);
		return queryAssetInfo.left;
	}

	@SuppressWarnings({ "rawtypes" })
	private Class getTClass() {
		// .getPage().getClass()有空指针问题
		Class classz = (Class) ((ParameterizedType) (resources.getContainer().getClass()).getGenericSuperclass())
				.getActualTypeArguments()[0];
		return classz;
	}

	public String getUrl() {
		TamsBean tamsBean = getTamsBean();
		String retUrl = tamsBean.url();
		if (StringUtil.isNull(retUrl)) {
			// 页面所在的类名
			String name = resources.getContainer().getClass().getName();
			String initParameter = servletContext.getInitParameter("tapestry.app-package");
			retUrl = name.replace(initParameter + ".pages", "").replace(".", "/");
		}
		return retUrl;
	}

	@Property
	private List<QueryAssetBean> queryItemList;

	@Property
	private QueryAssetBean queryItem;

	public String getTdClass() {
		return this.queryItem.isQuery() ? "frame_table_list_4_righttext" : "frame_table_list_2_righttext";
	}

	public int getPageEleWith() {
		int num = this.queryItem.getColspan() / 2 + 1;
		int lablenum = (num - 1) * 145;
		return this.queryItem.isQuery() ? 120 * num + lablenum : 250 * num + lablenum;
	}

	// 得到页面元素的id
	public String getPageEleId() {
		return String.format("%s_%s", this.queryItem.getColName(), this.queryItem.isQuery() ? "q" : "s");
	}

	// 判断当前的页面元素是否与指定的页面元素相等
	public boolean equal(String pageElementstr) {
		return this.queryItem.getPageElement() == PageElement.valueOf(pageElementstr);
	}

	public String pageElementOpt(PageElementOpt key) {
		Map<PageElementOpt, String> pageElementOpt = this.queryItem.getPageElementOpt();
		return pageElementOpt.containsKey(key) ? pageElementOpt.get(key) : key.getDefaultValue();
	}

	@SuppressWarnings("unchecked")
	protected Pair<List<Field>, List<Field>> querySaveInfo = EasyUiAssist.getQuerySaveInfo(getTClass());

	public List<List<QueryAssetBean>> getQueryItems() {
		return queryItemsCommon(true);
	}

	public List<List<QueryAssetBean>> getSaveItems() {
		return queryItemsCommon(false);
	}

	/***
	 * 按顺序
	 * 
	 * @param numPerRow
	 * @return
	 */
	private List<List<QueryAssetBean>> queryItemsCommon(boolean isQuery) {
		List<Field> collist = isQuery ? querySaveInfo.getLeft() : querySaveInfo.getRight();
		// 转化为最终对象
		List<QueryAssetBean> alllist = new ArrayList<QueryAssetBean>();
		for (Field ele : collist) {
			QueryAssetBean temp = new QueryAssetBean();
			TamsCol tamsCol = ele.getAnnotation(TamsCol.class);
			temp.setColLab(tamsCol.value());
			temp.setQuery(isQuery);
			if (!isQuery) {
				temp.setRequired(tamsCol.save() > 0 ? "true" : "false");
				// .setTdClass("frame_table_list_2_righttext");
			} else {
				temp.setRequired("false");
				// temp.setTdClass("frame_table_list_4_righttext");
			}
			temp.setColName(ele.getName());
			PageElement pageElement = tamsCol.pageElement();
			Map<PageElementOpt, String> findOpt = pageElement.findOpt(tamsCol);
			temp.setPageElement(pageElement);
			temp.setPageElementOpt(findOpt);
			temp.setColspan(tamsCol.colspan());
			alllist.add(temp);
		}
		// 分隔并补齐
		int numPerRow = isQuery ? 4 : 2;
		List<List<QueryAssetBean>> retlist = CollectionUtil.splitList(QueryAssetBean.class, alllist, numPerRow,
				new ICount<QueryAssetBean>() {
					@Override
					public int countObj(QueryAssetBean obj) {
						return obj.getColspan();
					}
				}, true);
		return retlist;
	}

}
