package net.wicp.tams.component.stack;

import java.util.Collections;
import java.util.List;

import javax.servlet.http.Cookie;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptAggregationStrategy;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StylesheetLink;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.constant.EasyUIStyle;
import net.wicp.tams.component.services.ISupportedLocales;

public class EasyUIStack implements JavaScriptStack {
	private final Mapper<String, StylesheetLink> pathToStyles;
	private final Mapper<String, Asset> pathToAsset;
	private final ISupportedLocales supportedLocales;
	private final RequestGlobals requestGlobals;

	public EasyUIStack(final AssetSource assetSource,
			@Symbol(SymbolConstantsCus.PATH_EASYUI) final String easyuipath,
			final ISupportedLocales supportedLocales,
			final RequestGlobals requestGlobals) {
		this.supportedLocales = supportedLocales;
		this.requestGlobals = requestGlobals;
		this.pathToStyles = new Mapper<String, StylesheetLink>() {
			public StylesheetLink map(String path) {
				return new StylesheetLink(
						assetSource.getClasspathAsset(easyuipath + path));
			}
		};
		this.pathToAsset = new Mapper<String, Asset>() {
			public Asset map(String path) {
				return assetSource.getExpandedAsset(easyuipath + path);
			}
		};
	}

	@Override
	public List<Asset> getJavaScriptLibraries() {
		String addStr = "zh";
		if ("zh".equals(supportedLocales.getCurLocale().getLanguage())) {
			addStr = "zh_CN";
		} else {
			addStr = supportedLocales.getCurLocale().getLanguage();
		}
		String langUrl = String.format("/locale/easyui-lang-%s.js", addStr);
		return F.flow("/jquery.easyui.min.js", langUrl).map(pathToAsset)
				.toList();
	}

	@Override
	public List<StylesheetLink> getStylesheets() {
		EasyUIStyle themeValue = EasyUIStyle.defaultSty;
		Cookie[] cookies = requestGlobals.getHTTPServletRequest().getCookies();
		if (ArrayUtils.isNotEmpty(cookies)) {
			for (Cookie cookie : cookies) {
				if (SymbolConstantsCus.EASYUI_DEFAULT_THEME_COOKKIENAME
						.equals(cookie.getName())
						&& StringUtil.isNotNull(cookie.getValue())) {
					themeValue = EasyUIStyle.valueOfDefault(cookie.getValue(),
							EasyUIStyle.defaultSty);// cookie设置的样式
					break;
				}
			}
		}
		return F.flow(
				String.format("/themes/%s/easyui.css", themeValue.getValue()),
				"/themes/icon.css").map(pathToStyles).toList();// icon一定要出现在easyui后面，否则树的图标无效
	}

	@Override
	public List<String> getStacks() {
		return Collections.emptyList();
	}

	@Override
	public List<String> getModules() {
		return Collections.emptyList();
	}

	@Override
	public JavaScriptAggregationStrategy getJavaScriptAggregationStrategy() {
		return JavaScriptAggregationStrategy.DO_NOTHING;
	}

	@Override
	public String getInitialization() {
		return null;
	}

}
