package net.wicp.tams.component.components;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

@Import(stylesheet = { "${path.comassets}/css/panel2.css" }, stack = "easyuistack")
public class Panel2 {

	@Parameter(value = "icon-find", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String iconCls;

	@Parameter(value = "prop:componentResources.id", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String id;

	@Inject
	protected Messages messages;// 国际化

	@Parameter(defaultPrefix = BindingConstants.MESSAGE)
	@Property
	private String title = messages.get("common.label.if");

	/***
	 * 定义查询按钮,示例：[{id:'saveBut',iconCls:'icon-save',text:'common.button.save'},{
	 * id:'deleteBut',iconCls:'icon-remove',text:'common.button.delete'}]
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private JSONArray buts;

	@Inject
	private ComponentResources resources;
	/***
	 * 是否需要图标
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean needicon;

	/***
	 * 是否需要标题
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean needtitle;
	/***
	 * 是否需要查询按钮
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean needQuery;

	/***
	 * 是否可折叠
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean collapsible;

	@Inject
	@Path("${path.comassets}/images/panel2/packup.png")
	@Property
	private Asset upImg;

	@Inject
	@Path("${path.comassets}/images/panel2/packout.png")
	@Property
	private Asset outImg;
	
	@Property
	private Block userBlock;//用户自定义的block
	
	/***
	 * 在buton后面的block块，可以放combox等元素来切换配置项
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String usrBlock;
	
	@BeforeRenderTemplate
	void init() {
		if (resources.isBound("usrBlock")) {
			userBlock = resources.getPage().getComponentResources().getBlock(usrBlock);
		}
	}
	

	// Render按钮
	public Renderable getActionButs() {
		return new Renderable() {
			@Override
			public void render(MarkupWriter writer) {
				List<JSONObject> butList = new ArrayList<JSONObject>();// 需要求的的按钮列表
				List<String> hasButIdList = new ArrayList<String>();// but的id
				if (needQuery) {
					// 添加默认的查询按钮
					String queryButIdString = id + "_query";
					hasButIdList.add(queryButIdString);
					butList.add(new JSONObject("id", queryButIdString, "iconCls", "icon-search", "text",
							"common.button.search"));
				}

				if (resources.isBound("buts")) {// 如果传进来按钮
					for (int i = 0; i < buts.length(); i++) {
						JSONObject butObject = buts.getJSONObject(i);
						String butIdString = butObject.has("id") ? butObject.getString("id") : "";
						if (StringUtils.isEmpty(butIdString) || !butObject.has("text")) {// 没有id或是text直接跳过
							continue;
						}
						int index = hasButIdList.indexOf(butIdString);
						if (index > -1) {// 覆盖默认已存在的按钮
							JSONObject jsonObject = butList.get(index);
							jsonObject.put("id", butObject.getString("id"));
							jsonObject.put("iconCls", butObject.has("iconCls") ? butObject.getString("iconCls") : "");
							jsonObject.put("text", butObject.getString("text"));
							hasButIdList.add(butObject.getString("id"));
							continue;
						}
						butList.add(butObject);
						hasButIdList.add(butObject.getString("id"));
					}
				}

				for (JSONObject but : butList) {
					Element element = writer.element("a", "id", but.getString("id"), "href", "javascript:void(0)",
							"class", "easyui-linkbutton", "style", "margin-right: 10px;vertical-align:middle", "plain",
							"true");//
					if (but.has("iconCls")) {
						element.attribute("data-options", "iconCls:'" + but.getString("iconCls") + "'");
					}

					Messages parentMsg = resources.getPage().getComponentResources().getMessages();
					String text = but.getString("text");
					String butText = parentMsg.contains(text) ? parentMsg.get(text) : text;// 得到页面的国际化信息
					element.text(butText);
					writer.end();
				}
			}
		};
	}
}
