/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.components;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.services.ISupportedLocales;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class Upload {
    public static final String prefix = "rjzjhuploadfield";
    public static final String prefix_exit = "rjzjhexistfield";
    @Inject
    @Path(value="${path.comassets}/images/add.png")
    @Property
    private Asset addImg;
    @Inject
    @Path(value="${path.comassets}/images/del.png")
    @Property
    private Asset delImg;
    @InjectService(value="locales")
    protected ISupportedLocales supportedLocales;
    @Inject
    protected JavaScriptSupport support;
    @Inject
    protected ComponentResources resources;
    @Inject
    protected Messages messages;
    @Parameter(defaultPrefix="literal")
    private String id;
    @Parameter(defaultPrefix="literal")
    private String name;
    @Environmental
    protected JavaScriptSupport javaScriptSupport;
    @Inject
    private AssetSource assetSource;
    @Parameter(value="false", defaultPrefix="literal")
    @Property
    private boolean multi;
    @Parameter(defaultPrefix="literal")
    private String initfile;
    @Property
    private Asset initFile;
    @Property
    private int index;
    @Inject
    @Symbol(value="path.file.upload.dir")
    private String defaultUploadDir;
    @Parameter(defaultPrefix="literal")
    @Property
    private String uploadDir;

    public Upload() {
        this.uploadDir = this.defaultUploadDir;
    }

    public String getPrefix() {
        return prefix;
    }

    public Asset[] getInitFiles() {
        if (this.resources.isBound("initfile") && StringUtil.isNotNull((Object)this.initfile)) {
            String[] fileStrs = this.initfile.split(",");
            Asset[] rets = new Asset[fileStrs.length];
            for (int i = 0; i < fileStrs.length; ++i) {
                rets[i] = this.assetSource.getExpandedAsset(this.uploadDir + "/" + fileStrs[i]);
            }
            return rets;
        }
        return new Asset[0];
    }

    public String getInitFileName() {
        int uploadRootIndex = this.uploadDir.indexOf(":");
        return this.initFile.getResource().getPath().toString().replace(this.uploadDir.substring(uploadRootIndex + 1) + "/", "");
    }

    public String getInitFileFiledName() {
        return prefix_exit + this.index;
    }

    @AfterRenderTemplate
    void afterRenderTemplate() {
        JSONObject spec = new JSONObject();
        spec.put("id", (Object)this.getId());
        spec.put("delImg", (Object)this.delImg.toString());
        spec.put("prefix", (Object)prefix);
        this.javaScriptSupport.require("init").invoke("uploadBind").with(new Object[]{spec});
    }

    public String getName() {
        if (this.multi) {
            return prefix;
        }
        if (!this.resources.isBound("name")) {
            return prefix;
        }
        return this.name;
    }

    public String getId() {
        if (!this.resources.isBound("id") && StringUtil.isNull((Object)this.id)) {
            this.id = this.support.allocateClientId(this.resources);
        }
        return this.id;
    }
}

