package net.wicp.tams.component.components.base;

import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;

public abstract class BaseValidateBox extends AbstractExtendableComponent {
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private boolean required;// 是否必填
	/*******
	 * 验证类型，是一个数组validType:['email','length[0,20]'],传过来的参数 email,
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray validType;
	/***
	 * 当输入框为空是提示,支持国际化
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String missingMessage;

	@Inject
	@Symbol(SymbolConstantsCus.INPUT_WIDTH)
	private int inputWidth;

	@Inject
	protected Messages messages;// 国际化

	/***
	 * 当输入框非法时提示
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.MESSAGE)
	private String invalidMessage;

	protected void writeFieldTag(MarkupWriter writer, final JSONObject spec) {
		packParms(spec);
		Element element = writer.element("input", "id", getClientId());
		if (spec.has("parent")) {// 为级联做特别处理，如果需要级联则把url显示到页面上
			element.attribute("url", spec.getJSONObject("params").getString("url"));
			// element.attribute("urlParam", spec.getString("urlParam"));
			element.attribute("parent", spec.getString("parent"));
		}

		if (resources.isBound("value"))
			element.attribute("value", value == null ? "" : String.valueOf(value));

		String componentsClass = spec.getString("class");// 是js的形式输出用的class类
		boolean ishtml = spec.has("ishtml") ? spec.getBoolean("ishtml") : false;// 是html的形式输出
		spec.remove("class");
		spec.remove("ishtml");
		if (StringUtils.isEmpty(componentsClass)) {// class是必须的
			return;
		}

		if (ishtml) {// html的形式输出
			element.attribute("class", "easyui-" + componentsClass);
			element.attribute("data-options", spec.getJSONObject("params").toString());
		} else {
			javaScriptSupport.require("init").invoke(componentsClass).with(spec);
		}
	}

	@AfterRender
	protected final void afterRender(MarkupWriter writer) {
		Element element = writer.getElement();
		String style = element.getAttribute("style");// 已有的样式
		// 合并样式。
		String widthStr = "width:" + inputWidth + "px";
		if (StringUtil.isNotNull(style)) {
			if (style.indexOf("width") < 0) {
				if (style.charAt(style.length() - 1) == ';') {
					style += widthStr;
				} else {
					style = style + ";" + widthStr;
				}
			}
		} else {
			style = widthStr;
		}
		element.forceAttributes("style", style);
		writer.end();
	}

	/****
	 * 子类需要调用此方法
	 * 
	 * @param spec
	 */
	protected void packParms(final JSONObject spec) {
		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("required"))
			params.put("required", required);
		if (resources.isBound("validType"))
			params.put("validType", validType);
		if (resources.isBound("missingMessage")) {
			final Messages mesparent = resources.getPage().getComponentResources().getMessages();
			if (StringUtil.isNotNull(missingMessage) && mesparent.contains(missingMessage)) {
				params.put("missingMessage", mesparent.get(missingMessage));
			} else {
				params.put("missingMessage", missingMessage);
			}
		}
		if (resources.isBound("invalidMessage"))
			params.put("invalidMessage", invalidMessage);
	}

}
