package net.wicp.tams.component.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.services.ISupportedLocales;

/****
 * 文件上传组件,可以支持多个文件的上传,可以显示已上传的多个文件
 * 
 * @author 周俊辉
 * 
 */
public class Upload {
	public static final String prefix = "rjzjhuploadfield";// 上传的文件域
	public static final String prefix_exit = "rjzjhexistfield";// 存在的文件隐藏域Name

	@Inject
	@Path("${path.comassets}/images/add.png")
	@Property
	private Asset addImg;

	@Inject
	@Path("${path.comassets}/images/del.png")
	@Property
	private Asset delImg;
	@InjectService("locales")
	protected ISupportedLocales supportedLocales;
	@Inject
	protected JavaScriptSupport support;
	@Inject
	protected ComponentResources resources;
	@Inject
	protected Messages messages;// 国际化

	/*
	 * @Parameter(value = "prop:componentResources.id", defaultPrefix =
	 * BindingConstants.LITERAL) private String id;
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String id;

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String name;

	@Environmental
	protected JavaScriptSupport javaScriptSupport;

	@Inject
	private AssetSource assetSource;

	/***
	 * 是否支持多个文件
	 */
	@Parameter(value = "false", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean multi;
	/***
	 * 初始文件地址,多个用","号分隔
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String initfile;

	public String getPrefix() {
		return prefix;
	}

	public Asset[] getInitFiles() {
		if (resources.isBound("initfile") && StringUtil.isNotNull(initfile)) {
			String[] fileStrs = initfile.split(",");
			Asset[] rets = new Asset[fileStrs.length];
			for (int i = 0; i < fileStrs.length; i++) {
				rets[i] = assetSource.getExpandedAsset(uploadDir + "/"
						+ fileStrs[i]);
			}
			return rets;
		}
		return new Asset[0];
	}

	@Property
	private Asset initFile;
	@Property
	private int index;

	public String getInitFileName() {
		int uploadRootIndex = uploadDir.indexOf(":");
		return initFile.getResource().getPath().toString()
				.replace(uploadDir.substring(uploadRootIndex + 1) + "/", "");
	}

	public String getInitFileFiledName() {
		return prefix_exit + index;
	}

	@Inject
	@Symbol(SymbolConstantsCus.PATH_FILE_UPLOAD_DIR)
	private String defaultUploadDir;// 默认的文件上传目录,在service里配置

	/***
	 * 初始文件地址,多个用","号分隔
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String uploadDir = defaultUploadDir;

	@AfterRenderTemplate
	void afterRenderTemplate() {
		JSONObject spec = new JSONObject();
		spec.put("id", getId());
		spec.put("delImg", delImg.toString());
		spec.put("prefix", prefix);
		javaScriptSupport.require("init").invoke("uploadBind").with(spec);
	}

	/****
	 * 得到name属性
	 * 
	 * @return
	 */
	public String getName() {
		if (multi) {// 如果是多个则name参数无效.
			return prefix;
		} else {
			if (!resources.isBound("name")) {
				return prefix;
			} else {
				return this.name;
			}
		}
	}

	/***
	 * 得到id
	 * 
	 * @return
	 */
	public String getId() {
		if (!resources.isBound("id") && StringUtil.isNull(id)) {
			id = support.allocateClientId(resources);
		}
		return this.id;
	}
}
