package net.wicp.tams.component.encoder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.tapestry5.ValueEncoder;

import net.wicp.tams.common.constant.DateFormatCase;


/*****
 * 日期的转换
 * 
 * @author Administrator
 * 
 */
public class DateEncoder implements ValueEncoder<Date> {
	private SimpleDateFormat simpleDateFormat = DateFormatCase.YYYY_MM_DD
			.getInstanc();// 默认的格式为'yyyy-MM-dd'

	public DateEncoder() {
	}

	public DateEncoder(DateFormatCase dateformate) {
		this.simpleDateFormat = dateformate.getInstanc();
	}

	public DateEncoder(String dateformateStr) {
		this.simpleDateFormat = new SimpleDateFormat(dateformateStr);
	}

	@Override
	public String toClient(Date value) {
		return simpleDateFormat.format(value);
	}

	@Override
	public Date toValue(String clientValue) {
		try {
			return simpleDateFormat.parse(clientValue);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

}
