/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.duckula.plugin.receiver;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Properties;
import net.wicp.tams.common.Plugin;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.duckula.plugin.beans.DuckulaPackage;
import net.wicp.tams.duckula.plugin.beans.Rule;
import net.wicp.tams.duckula.plugin.constant.RuleItem;
import net.wicp.tams.duckula.plugin.receiver.IReceiver;

public abstract class ReceiveAbs
implements IReceiver {
    public static final String colParam = "colParam";
    public static final String colTaskId = "colTaskId";
    public static final String colMiddlewareType = "colMiddlewareType";
    public static final String colMiddlewareInst = "colMiddlewareInst";
    protected final JSONObject params;
    protected final String taskId;
    protected final Properties props;

    public static IReceiver loadReceive(Plugin plugin, JSONObject params) {
        IReceiver retobj = (IReceiver)plugin.newObject(params);
        return retobj;
    }

    public ReceiveAbs(JSONObject paramObjs) {
        this.params = paramObjs.getJSONObject(colParam);
        this.taskId = paramObjs.getString(colTaskId);
        String middlewareType = paramObjs.getString(colMiddlewareType);
        String middlewareInst = paramObjs.getString(colMiddlewareInst);
        this.props = this.configMiddleware(middlewareType, middlewareInst);
    }

    private Properties configMiddleware(String middlewareType, String middlewareInst) {
        String mergeFolderAndFilePath = IOUtil.mergeFolderAndFilePath((String)System.getenv("DUCKULA_DATA"), (String[])new String[]{String.format("/conf/%s/%s-%s.properties", middlewareType, middlewareType, middlewareInst)});
        Properties retProps = IOUtil.fileToProperties((File)new File(mergeFolderAndFilePath));
        return retProps;
    }

    @Override
    public boolean receiveMsg(DuckulaPackage duckulaPackage, Rule rule) {
        String splitKey = StringUtil.isNull(rule.getItems().get(RuleItem.splitkey)) ? duckulaPackage.getEventTable().getCols()[0] : (String)rule.getItems().get(RuleItem.splitkey);
        return this.receiveMsg(duckulaPackage, rule, splitKey);
    }

    public abstract boolean receiveMsg(DuckulaPackage var1, Rule var2, String var3);
}

