package net.wicp.tams.duckula.plugin.receiver;

import java.io.File;
import java.util.Properties;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Plugin;
import net.wicp.tams.common.apiext.IOUtil;

public abstract class ReceiveAbs implements IReceiver {
	public static final String colParam = "colParam";
	public static final String colTaskId = "colTaskId";
	public static final String colMiddlewareType = "colMiddlewareType";
	public static final String colMiddlewareInst = "colMiddlewareInst";

	// "net.wicp.tams.duckula.plugin.IReceive","net.wicp.tams.duckula.plugin.ReceiveAbs"
	public static IReceiver loadReceive(Plugin plugin, JSONObject params) {
		IReceiver retobj = (IReceiver) plugin.newObject(params);
		return retobj;
	}

	protected final JSONObject params;
	protected final String taskId;

	protected final Properties props;
	// protected final Logger log;

	public ReceiveAbs(JSONObject paramObjs) {
		params = paramObjs.getJSONObject(colParam);
		taskId = paramObjs.getString(colTaskId);
		String middlewareType = paramObjs.getString(colMiddlewareType);
		String middlewareInst = paramObjs.getString(colMiddlewareInst);
		props = configMiddleware(middlewareType, middlewareInst);
	}

	private Properties configMiddleware(String middlewareType, String middlewareInst) {
		String mergeFolderAndFilePath = IOUtil.mergeFolderAndFilePath(System.getenv("DUCKULA_DATA"),
				String.format("/conf/%s/%s-%s.properties", middlewareType, middlewareType, middlewareInst));
		Properties retProps = IOUtil.fileToProperties(new File(mergeFolderAndFilePath));
		return retProps;
	}
}
