package net.wicp.tams.duckula.plugin.receiver;

import java.util.List;

import net.wicp.tams.duckula.plugin.beans.DuckulaPackage;
import net.wicp.tams.duckula.plugin.beans.Rule;
import net.wicp.tams.duckula.plugin.beans.SingleRecord;

/***
 * 构造函数需要一个参数Map
 * 
 * @author rjzjh
 *
 */
public interface IReceiver {
	/***
	 * 未序列化数据
	 * 
	 * @param duckulaPackage
	 *            数据包
	 * @param rule
	 *            规则
	 * @return
	 */
	public boolean receiveMsg(DuckulaPackage duckulaPackage, Rule rule);// 插件必须实现

	/***
	 * 序列化后的数据
	 */
	public boolean receiveMsg(List<SingleRecord> data, Rule rule);// 插件必须实现
	
	/***
	 * 是同步还是异步发送 kafka/redis：否  es：是
	 * @return
	 */
	public boolean isSync();
}
