package net.wicp.tams.duckula.plugin.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.duckula.plugin.constant.RuleItem;

@Data
@Slf4j
public class Rule {
	private String dbPattern;
	private String tbPattern;
	private String drds;// dbtb 分库也分表 db 只分库 no 不分库分表
	// private String splitKey;//
	// private String remark;
	Map<RuleItem, String> items = new HashMap<>();

	public static String drdsTbPatternFormat1 = "^%s_[0-9a-zA-Z]{4}";

	public static String drdsTbPatternFormat2 = "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$";

	private int dbLength;

	private int tbLength;

	public JSONObject buildRuleItem() {
		JSONObject retobj = new JSONObject();
		for (RuleItem ruleItem : items.keySet()) {
			retobj.put(ruleItem.name(), items.get(ruleItem));
		}
		return retobj;
	}

	public static String buildOriRule(String ruleStr) {
		String retStr = ruleStr.replaceAll("\\^", "").replaceAll("\\$", "").replaceAll("\\[0-9\\]\\*", "")
				.replaceAll("_\\[0-9a-zA-Z\\]\\{4\\}", "").replaceAll("_\\[0-9\\]\\{2,\\}", "");
		return retStr;
	}

	public static List<Rule> buildRules(String rules) {
		List<Rule> ruleList = new ArrayList<>();
		if (StringUtil.isNull(rules)) {
			return ruleList;
		}
		String[] ruleAry = rules.split("&");
		for (int i = 0; i < ruleAry.length; i++) {
			String[] ruleValues = ruleAry[i].split("`");
			if (ruleValues.length == 0 || (ruleValues.length != 3 && ruleValues.length != 4)) {
				throw new IllegalArgumentException("规则长度只能为3或4!");
			}
			Rule rule = new Rule();

			String itemStr = ruleValues[2];
			boolean isdrds = false;
			if (ruleValues.length > 3) {
				rule.setDrds(ruleValues[2]);
				itemStr = ruleValues[3];
				isdrds = true;
			}
			if (isdrds) {
				rule.setDbPattern(String.format(Rule.drdsTbPatternFormat2, ruleValues[0]));// drds支持
			} else {
				rule.setDbPattern(buildPatter(ruleValues[0]));
			}
			rule.setDbLength(ruleValues[0].length());

			String tbpatternstr = buildPatter(ruleValues[1]);
			if (isdrds) {
				if ("dbtb".equals(rule.getDrds())) {
					tbpatternstr = String.format(Rule.drdsTbPatternFormat2, ruleValues[1]);// drds支持
				} else if ("db".equals(rule.getDrds())) {
					tbpatternstr = String.format(Rule.drdsTbPatternFormat1, ruleValues[1]);// drds支持
				} else if ("no".equals(rule.getDrds())) {
					tbpatternstr = ruleValues[1];
				}
			}
			rule.setTbPattern(tbpatternstr);
			rule.setTbLength(ruleValues[1].length());

			JSONObject json = JSON.parseObject(itemStr);
			for (String key : json.keySet()) {
				RuleItem tempItem = RuleItem.get(key);
				if (tempItem == null) {
					log.error("规则设置出错，请检查key与发送者!");
					throw new IllegalArgumentException("规则设置出错，请检查key与发送者!");
				} else {
					rule.getItems().put(tempItem, json.getString(key));
				}
			}
			ruleList.add(rule);
		}
		return ruleList;
	}

	private static String buildPatter(String patter) {
		if (patter.endsWith("_")) {
			return String.format("^%s[0-9]*$", patter);
		} else {
			return String.format("^%s$", patter);
		}
	}

	@Override
	public boolean equals(Object obj) {
		Rule temp = (Rule) obj;
		return this.dbPattern.equals(temp.getDbPattern()) && this.tbPattern.equals(temp.getTbPattern());
	}

	@Override
	public int hashCode() {
		return this.dbPattern.hashCode() * 37 + this.tbPattern.hashCode();
	}
}
