/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.duckula.plugin.beans;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.duckula.plugin.constant.RuleItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rule {
    private static final Logger log = LoggerFactory.getLogger(Rule.class);
    private String dbPattern;
    private String tbPattern;
    private String drds;
    Map<RuleItem, String> items = new HashMap<RuleItem, String>();
    public static String drdsTbPatternFormat1 = "^%s_[0-9a-zA-Z]{4}";
    public static String drdsTbPatternFormat2 = "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$";
    private int dbLength;
    private int tbLength;

    public static String buildOriRule(String ruleStr) {
        String retStr = ruleStr.replaceAll("\\^", "").replaceAll("\\$", "").replaceAll("\\[0-9\\]\\*", "").replaceAll("_\\[0-9a-zA-Z\\]\\{4\\}", "").replaceAll("_\\[0-9\\]\\{2,\\}", "");
        return retStr;
    }

    public static List<Rule> buildRules(String rules) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (StringUtil.isNull((Object)rules)) {
            return ruleList;
        }
        String[] ruleAry = rules.split("&");
        for (int i = 0; i < ruleAry.length; ++i) {
            String[] ruleValues = ruleAry[i].split("`");
            if (ruleValues.length == 0 || ruleValues.length != 3 && ruleValues.length != 4) {
                throw new IllegalArgumentException("\u89c4\u5219\u957f\u5ea6\u53ea\u80fd\u4e3a3\u62164!");
            }
            Rule rule = new Rule();
            String itemStr = ruleValues[2];
            boolean isdrds = false;
            if (ruleValues.length > 3) {
                rule.setDrds(ruleValues[2]);
                itemStr = ruleValues[3];
                isdrds = true;
            }
            if (isdrds) {
                rule.setDbPattern(String.format(drdsTbPatternFormat2, ruleValues[0]));
            } else {
                rule.setDbPattern(Rule.buildPatter(ruleValues[0]));
            }
            rule.setDbLength(ruleValues[0].length());
            String tbpatternstr = Rule.buildPatter(ruleValues[1]);
            if (isdrds) {
                if ("dbtb".equals(rule.getDrds())) {
                    tbpatternstr = String.format(drdsTbPatternFormat2, ruleValues[1]);
                } else if ("db".equals(rule.getDrds())) {
                    tbpatternstr = String.format(drdsTbPatternFormat1, ruleValues[1]);
                } else if ("no".equals(rule.getDrds())) {
                    tbpatternstr = ruleValues[1];
                }
            }
            rule.setTbPattern(tbpatternstr);
            rule.setTbLength(ruleValues[1].length());
            JSONObject json = JSON.parseObject((String)itemStr);
            for (String key : json.keySet()) {
                RuleItem tempItem = RuleItem.get(key);
                if (tempItem == null) {
                    log.error("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                    throw new IllegalArgumentException("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                }
                rule.getItems().put(tempItem, json.getString(key));
            }
            ruleList.add(rule);
        }
        return ruleList;
    }

    private static String buildPatter(String patter) {
        if (patter.endsWith("_")) {
            return String.format("^%s[0-9]*$", patter);
        }
        return String.format("^%s$", patter);
    }

    public String getDbPattern() {
        return this.dbPattern;
    }

    public String getTbPattern() {
        return this.tbPattern;
    }

    public String getDrds() {
        return this.drds;
    }

    public Map<RuleItem, String> getItems() {
        return this.items;
    }

    public int getDbLength() {
        return this.dbLength;
    }

    public int getTbLength() {
        return this.tbLength;
    }

    public void setDbPattern(String dbPattern) {
        this.dbPattern = dbPattern;
    }

    public void setTbPattern(String tbPattern) {
        this.tbPattern = tbPattern;
    }

    public void setDrds(String drds) {
        this.drds = drds;
    }

    public void setItems(Map<RuleItem, String> items) {
        this.items = items;
    }

    public void setDbLength(int dbLength) {
        this.dbLength = dbLength;
    }

    public void setTbLength(int tbLength) {
        this.tbLength = tbLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dbPattern = this.getDbPattern();
        String other$dbPattern = other.getDbPattern();
        if (this$dbPattern == null ? other$dbPattern != null : !this$dbPattern.equals(other$dbPattern)) {
            return false;
        }
        String this$tbPattern = this.getTbPattern();
        String other$tbPattern = other.getTbPattern();
        if (this$tbPattern == null ? other$tbPattern != null : !this$tbPattern.equals(other$tbPattern)) {
            return false;
        }
        String this$drds = this.getDrds();
        String other$drds = other.getDrds();
        if (this$drds == null ? other$drds != null : !this$drds.equals(other$drds)) {
            return false;
        }
        Map<RuleItem, String> this$items = this.getItems();
        Map<RuleItem, String> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        if (this.getDbLength() != other.getDbLength()) {
            return false;
        }
        return this.getTbLength() == other.getTbLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dbPattern = this.getDbPattern();
        result = result * 59 + ($dbPattern == null ? 43 : $dbPattern.hashCode());
        String $tbPattern = this.getTbPattern();
        result = result * 59 + ($tbPattern == null ? 43 : $tbPattern.hashCode());
        String $drds = this.getDrds();
        result = result * 59 + ($drds == null ? 43 : $drds.hashCode());
        Map<RuleItem, String> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        result = result * 59 + this.getDbLength();
        result = result * 59 + this.getTbLength();
        return result;
    }

    public String toString() {
        return "Rule(dbPattern=" + this.getDbPattern() + ", tbPattern=" + this.getTbPattern() + ", drds=" + this.getDrds() + ", items=" + this.getItems() + ", dbLength=" + this.getDbLength() + ", tbLength=" + this.getTbLength() + ")";
    }
}

