package net.wicp.tams.duckula.plugin.constant;

import org.apache.commons.lang3.Validate;

import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

public enum RuleItem {
	topic("消息主题"),

	key("redis的keys,es需要主键的colName"), //

	relakey("es中关联表的key"), // "table1:key|table2:key",如果只有一张表直接输入key名就OK

	appid("cachecloud的使用类型和appid，中间用|分隔，默认为standalone"), // 格式“standalone|10000”或 “sentinel|10000”

	redisurl("redis的url"), // ,格式“standalone|127.0.0.1:6279”或
							// “sentinel|mastername|127.0.0.1:6279,127.0.0.1:6278,127.0.0.1:6277”
							// “null”或者不配置就使用middleware的配置结果

	splitkey("分库分表键"),

	index("es的index"),

	type("es的type"),

	copynum("复制份数"), // es自动创建index用

	partitions("分区数"), // es自动创建index用

	middleware("存储中间件配置"), // es消费时需要指定中间件的配置

	dbinstanceid("consumer的jdbc发送者需要"),

	dbtb("consumer的jdbc发送者需要，中间用.分隔"),
	
	ks("cassandra用的名称空间"), //20200122 cassandra等使用的名称空间
	
	table("consumer的jdbc发送者需要，中间用.分隔"),//20200122 cassandra等数据库使用的表名

	other("未知参数");

	private final String desc;

	private RuleItem(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public static String[] splitAppId(String appidValue) {
		Validate.notEmpty(appidValue, "appid不能为空值");
		String[] splitary = appidValue.split("\\|");
		if (splitary.length == 1) {
			return new String[] { "standalone", splitary[0] };
		} else {
			return splitary;
		}
	}

	public static String[] splitRedisurl(String redisurlValue) {
		Validate.notEmpty(redisurlValue, "redisurl不能为空值");
		String[] splitary = redisurlValue.split("\\|");
		Validate.isTrue(splitary.length > 1, "redisurl格式不对");
		if ("standalone".equals(splitary[0])) {
			return splitary;
		} else if ("sentinel".equals(splitary[0])) {
			String[] hostandports = splitary[2].split(",");
			String[] retary = new String[hostandports.length + 2];
			retary[0] = splitary[0];
			retary[1] = splitary[1];
			System.arraycopy(hostandports, 0, retary, 2, hostandports.length);
			return retary;
		} // 集群未支持
		throw new ProjectExceptionRuntime(ExceptAll.project_nosupport);
	}

	public static RuleItem get(String name) {
		for (RuleItem ruleItem : RuleItem.values()) {
			if (ruleItem.name().equalsIgnoreCase(name)) {
				return ruleItem;
			}
		}
		return null;
	}
	

}
