package net.wicp.tams.duckula.plugin.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.duckula.plugin.constant.RuleItem;

@Data
@Slf4j
public class Rule {
	private String dbPattern;
	private String tbPattern;
	private String drds;// dbtb 分库也分表 db 只分库 no 不分库分表
	// private String splitKey;//
	// private String remark;
	Map<RuleItem, String> items = new HashMap<>();

	public static List<Rule> buildRules(String rules) {
		List<Rule> retlist = new ArrayList<Rule>();
		if (StringUtil.isNull(rules)) {
			return retlist;
		}
		String[] ruleAry = rules.split("&");
		for (int i = 0; i < ruleAry.length; i++) {
			String[] ruleValues = ruleAry[i].split("`");
			if (ruleValues.length == 0 || ruleValues.length != 3) {
				throw new IllegalArgumentException("规则长度只能为３!");
			}
			Rule rule = new Rule();
			rule.setDbPattern(buildPatter(ruleValues[0]));
			rule.setTbPattern(buildPatter(ruleValues[1]));
			JSONObject json = JSON.parseObject(ruleValues[2]);
			for (String key : json.keySet()) {
				RuleItem tempItem = RuleItem.get(key);
				if (tempItem == null) {
					log.error("规则设置出错，请检查【{}】是否在net.wicp.tams.duckula.plugin.constant.RuleItem中定义!", key);
					throw new IllegalArgumentException(
							"规则设置出错，请检查【" + key + "】是否在net.wicp.tams.duckula.plugin.constant.RuleItem中定义!");
				} else {
					rule.getItems().put(tempItem, json.getString(key));
				}
			}
			retlist.add(rule);
		}
		return retlist;
	}

	private static String buildPatter(String patter) {
		if (patter.endsWith("_")) {
			return String.format("^%s[0-9]*$", patter);
		} else {
			return String.format("^%s$", patter);
		}
	}
}
