package net.wicp.tams.duckula.plugin;

import lombok.Data;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.duckula.plugin.beans.Rule;

import java.util.List;

@Data
public class RuleManager {

    private List<Rule> rules;

    public RuleManager(List<Rule> rules) {
        this.rules = rules;
    }

    /***
     * 找到表的匹配规则
     *
     * @param db
     * @param tb
     * @return
     */
    public Rule findRule(String db, String tb) {
        for (Rule rule : this.getRules()) {
            if (!"^*$".equals(rule.getDbPattern())) {
                boolean retdb = StrPattern.checkStrFormat(rule.getDbPattern(), db);
                if (!retdb) {
                    continue;
                }
            }
            if (!"^*$".equals(rule.getTbPattern())) {
                boolean rettb = StrPattern.checkStrFormat(rule.getTbPattern(), tb);
                if (!rettb) {
                    continue;
                }
            }
            return rule;
        }
        return null;
    }
}
