package net.wicp.tams.duckula.plugin;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.json.SimpleTreeNode;
import net.wicp.tams.duckula.plugin.beans.Rule;

import java.util.List;
import java.util.Set;

/***
 * ops需要插件化的操作
 *
 * @author Administrator
 *
 */
public interface IOps {
    /**
     * 创建索引
     *
     * @param ruleStr
     * @param cluster
     * @param ip
     * @param port
     * @param user
     * @param pwd
     * @return
     */
    List<Rule> createIndex(String ruleStr, String cluster, String ip, int port, String user, String pwd);

    /**
     * 得到context
     *
     * @param ip
     * @param port
     * @param user
     * @param pwd
     * @param db
     * @param tb
     * @return
     */
    String createContext(String ip, int port, String user, String pwd, String db, String tb);

    /**
     * 根据昵称规则和昵称前缀找出所有昵称
     *
     * @param cluster
     * @param aliasesPattern 昵称规则
     * @param aliasPrefix    昵称前缀
     * @return
     */
    Set<String> getAliases(String cluster, String aliasesPattern, String aliasPrefix);

    /**
     * @param cluster
     * @param indexPattern 索引规则
     * @param index        索引全称
     * @return
     */
    boolean isExists(String cluster, String indexPattern, String index);

    /**
     * 得到索引的JSON格式
     *
     * @param cluster
     * @return
     */
    String getIndicesJson(String cluster);

    /**
     * 对索引重命名
     *
     * @param cluster
     * @param oldIndex 旧索引
     * @param newIndex 新索引
     * @param aliases  昵称
     * @return
     */
    Result renameIndex(String cluster, String oldIndex, String newIndex, String[] aliases);

    /**
     * 创建索引昵称
     *
     * @param cluster
     * @param indexNamePatten 索引名称规则
     * @param aliases         昵称
     * @return
     */
    Result aliasCreate(String cluster, String indexNamePatten, String... aliases);

    /**
     * 打包索引上下文
     *
     * @param colName
     * @param colType
     * @param nodes
     * @return
     */
    String packIndexContent(String[] colName, String[] colType, List<SimpleTreeNode> nodes);

    /**
     * @param mappingId
     * @param index
     * @param type
     * @param content
     * @param shardsNum
     * @param replicas
     * @return
     */
    Result createIndex(String cluster, String mappingId, String index, String type, String content, int shardsNum, int replicas);

}
