/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.duckula.client;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.wicp.tams.duckula.client.Protobuf3;
import org.apache.commons.codec.binary.Base64;

public abstract class DuckulaAssit {
    public static Protobuf3.DuckulaEvent parse(byte[] data) throws InvalidProtocolBufferException {
        Protobuf3.DuckulaEvent retobj = Protobuf3.DuckulaEvent.parseFrom(data);
        return retobj;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static <T extends Serializable> T getValueAfter(Protobuf3.DuckulaEvent duckulaEvent, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, colName, true);
    }

    public static <T extends Serializable> T getValueBefore(Protobuf3.DuckulaEvent duckulaEvent, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, colName, false);
    }

    public static <T extends Serializable> T getValue(Protobuf3.DuckulaEvent duckulaEvent, String colName) {
        if (duckulaEvent.getOptType() == Protobuf3.OptType.delete) {
            return DuckulaAssit.getValue(duckulaEvent, colName, false);
        }
        return DuckulaAssit.getValue(duckulaEvent, colName, true);
    }

    public static String getValueStr(Protobuf3.DuckulaEvent duckulaEvent, String colName) {
        Map<String, String> data = null;
        data = duckulaEvent.getOptType() == Protobuf3.OptType.delete ? duckulaEvent.getBeforeMap() : duckulaEvent.getAfterMap();
        String value = data.get(colName);
        return value;
    }

    public static <T extends Serializable> T getValue(Protobuf3.DuckulaEvent duckulaEvent, String colName, boolean isAfter) {
        if (duckulaEvent.getColsCount() != duckulaEvent.getColsList().size()) {
            throw new RuntimeException("\u5217\u540d\u4e0e\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002");
        }
        Map<String, String> data = null;
        data = isAfter ? duckulaEvent.getAfterMap() : duckulaEvent.getBeforeMap();
        if (data == null || data.size() == 0) {
            return null;
        }
        String value = data.get(colName);
        if (DuckulaAssit.isEmpty(value)) {
            return null;
        }
        int colindex = duckulaEvent.getColsList().indexOf((Object)colName);
        Protobuf3.ColumnType columnType = duckulaEvent.getColsType(colindex);
        Object retobj = null;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case DECIMAL: 
            case NEWDECIMAL: {
                retobj = new BigDecimal(value);
                break;
            }
            case BLOB: 
            case GEOMETRY: {
                try {
                    retobj = Base64.decodeBase64((String)value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case YEAR: {
                try {
                    retobj = Integer.valueOf(value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case TIMESTAMP2: 
            case DATETIME2: {
                try {
                    SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    retobj = formater.parse(value);
                }
                catch (ParseException e) {
                    retobj = value;
                }
                break;
            }
            default: {
                retobj = value;
            }
        }
        return (T)retobj;
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }
}

