package net.wicp.tams.component.services.base;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.annotation.HtmlJs;
import net.wicp.tams.component.constant.EasyUIAdd;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.services.impl.JqDocLinkerImpl;

/******
 * 项目需要完成页面Rend前的初始化动作
 * 
 * @author Administrator
 * 
 */
public class PageWorker implements ComponentClassTransformWorker2 {

	private final AssetSource assetSource;
	private final JavaScriptSupport javaScriptSupport;
	private final String contextPath;
	private final RequestGlobals requestGlobals;
	private final ISupportedLocales supportedLocales;
	private final Environment environment;
	private final String easyuipath;
	private final String rjzjhpath;

	public PageWorker(AssetSource assetSource, JavaScriptSupport javaScriptSupport, RequestGlobals requestGlobals,
			Environment environment, @Symbol(SymbolConstants.CONTEXT_PATH) String contextPath,
			@Symbol(SymbolConstantsCus.PATH_COMASSETS) String rjzjhpath,
			@Symbol(SymbolConstantsCus.PATH_EASYUI) final String easyuipath, ISupportedLocales supportedLocales) {
		this.easyuipath = easyuipath;
		this.assetSource = assetSource;
		this.javaScriptSupport = javaScriptSupport;
		this.contextPath = contextPath;
		this.supportedLocales = supportedLocales;
		this.environment = environment;
		this.rjzjhpath = rjzjhpath;
		this.requestGlobals = requestGlobals;
	}

	@Override
	public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
		PlasticMethod setupRender = plasticClass.introduceMethod(TransformConstants.SETUP_RENDER_DESCRIPTION);
		model.enableSupportsInformalParameters();// 使组件支持非正式参数

		// 支持 HtmlJs 注解类
		final HtmlJs htmlJs = plasticClass.getAnnotation(HtmlJs.class);// 支持HtmlJs标签
		if (htmlJs != null) {
			setupRender.addAdvice(new MethodAdvice() {
				public void advise(MethodInvocation invocation) {
					JqDocLinkerImpl linker = (JqDocLinkerImpl) environment.peekRequired(DocumentLinker.class);// 只有在此环境中才能得到此对象，放到外面不行
					if (ArrayUtils.isNotEmpty(htmlJs.turl())) {// tapestry规则地址，默认为
																// classpath:
						for (String jsurl : htmlJs.turl()) {
							String urlTrue = assetSource.getExpandedAsset(jsurl).toClientURL();
							linker.addHtmlLibrary(urlTrue);
						}
					}
					if (ArrayUtils.isNotEmpty(htmlJs.url())) {// 统一url地址
						for (String jsurl : htmlJs.url()) {
							linker.addHtmlLibrary(jsurl);
						}
					}
					if (ArrayUtils.isNotEmpty(htmlJs.easyuiadd())) {
						for (EasyUIAdd add : htmlJs.easyuiadd()) {
							String addUrl = String.format("%s/%s", easyuipath, add.getJsName());
							linker.addHtmlLibrary(assetSource.getExpandedAsset(addUrl).toClientURL());
						}
					}

					// linker.addHtmlLibrary(rjzjhpath + "/config.js");//
					// 添加require的config
					invocation.proceed();
				}
			});
		}

		if (model.isPage()) {// 是根页面 && model.isRootClass()
			setupRender.addAdvice(new MethodAdvice() {
				public void advise(MethodInvocation invocation) {
					javaScriptSupport.require("init").invoke("initGlobal").priority(InitializationPriority.LATE)
							.with(new org.apache.tapestry5.json.JSONObject());// 每个页面都会调一个初始化方法，init()可以替代
																				// JQuery的ready方法.
					javaScriptSupport.importJavaScriptLibrary(
							assetSource.getExpandedAsset(rjzjhpath + "/config.js").toClientURL());// 自定义require的config的配置
					invocation.proceed();
				}
			});
		}
		model.addRenderPhase(SetupRender.class); // 必须要有，如果没有此又没有@SetupRender时会导到整个work不起作用
	}
}
