package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.component.components.base.AbstractExtendableComponent;


/***
 * 面板组件 panel
 * 
 * @author 周俊辉
 * 
 */
@Import(stack = "easyuistack")
public class Panel extends AbstractExtendableComponent {
	/****
	 * 标题<br/>
	 * 类型：key
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String title;

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String iconCls;
	/****
	 * 距离左边的高度<br/>
	 * 类型：整型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private Integer left;
	/****
	 * 距离顶端的高度<br/>
	 * 类型：整型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private Integer top;
	/**
	 * 是否显示可折叠按钮<br/>
	 * 类型：布尔型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private Boolean collapsible;
	/**
	 * 是否显示最小化按钮<br/>
	 * 类型：布尔型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private Boolean minimizable;
	/**
	 * 是否显示最大化按钮<br/>
	 * 类型：布尔型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private Boolean maximizable;
	/**
	 * 是否显示关闭按钮<br/>
	 * 类型：布尔型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private Boolean closable;

	/****
	 * 公共参数：组件宽度。
	 * 类型：整型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	protected Integer width;
	/****
	 * 公共参数：组件高度。
	 * 类型：整型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	protected Integer height;
	/****
	 * 是否自动适合父窗口大小,默认为true
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean fit;

	@SetupRender
	void setup() {// 初始化值
		setDefaultMethod("uploadable");
	}

	protected void writeFieldTag(MarkupWriter writer,final JSONObject spec) {
		packSpec(spec);
		writer.element("div", "id", getClientId(), "class", "easyui-panel",
				"data-options", spec.getJSONObject("params"));
	}

	protected void packSpec(final JSONObject spec) {
		JSONObject params = spec.getJSONObject("params");		
		if (resources.isBound("width"))
			params.put("width", width);
		if (resources.isBound("height"))
			params.put("height", height);
		if (resources.isBound("title"))
			params.put("title", title);
		if (resources.isBound("iconCls"))
			params.put("iconCls", iconCls);
		if (resources.isBound("left"))
			params.put("left", left);
		if (resources.isBound("top"))
			params.put("top", top);
		if (resources.isBound("closable"))
			params.put("closable", closable);
		if (resources.isBound("maximizable"))
			params.put("maximizable", maximizable);
		if (resources.isBound("minimizable"))
			params.put("minimizable", minimizable);
		if (resources.isBound("collapsible"))
			params.put("collapsible", collapsible);
		
		params.put("fit", fit);
	}

	@AfterRender
	final void afterRender(MarkupWriter writer) {
		writer.end();
	}

}
