package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;

/*****
 * 时间控件
 * 
 * @author 周俊辉
 * 
 */
@Import(stack = "easyuistack")
public class TimeSpinner extends ValidateBox {
	/***
	 * 组件宽度
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int width;

	/***
	 * 组件高度
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int height;

	/***
	 * 增长单位
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int increment;

	/***
	 * 是否可能直接输入值修改,默认为可以
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean editable;
	/***
	 * 当点击向上或向下时触发的函数：function(down)
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String spin;

	/***
	 * disabled
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean disabled;
	/***
	 * 最小值
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String min;
	/***
	 * 最大值
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String max;

	/***
	 * 时钟和分钟的分隔符
	 */
	@Parameter(required = false, value = ":", defaultPrefix = BindingConstants.LITERAL)
	private String separator;

	/***
	 * 是否显示秒钟
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean showSeconds;

	/***
	 * 初始时要调整的区域，0 = hours, 1 = minutes, …
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int highlight;

	@Override
	protected void packParms(JSONObject spec) {
		super.packParms(spec);
		spec.put("class", "timespinner");
		spec.put("ishtml", false);

		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("width"))
			params.put("width", width);
		if (resources.isBound("height"))
			params.put("height", height);
		if (resources.isBound("increment"))
			params.put("increment", increment);
		if (resources.isBound("editable"))
			params.put("editable", editable);
		if (resources.isBound("spin"))
			spec.put("spin", spin);

		if (resources.isBound("disabled"))
			params.put("disabled", disabled);
		if (resources.isBound("min"))
			params.put("min", min);
		if (resources.isBound("max"))
			params.put("max", max);
		if (resources.isBound("separator"))
			params.put("separator", separator);
		if (resources.isBound("showSeconds"))
			params.put("showSeconds", showSeconds);
		if (resources.isBound("highlight"))
			params.put("highlight", highlight);

	}

	boolean beforeRenderBody() {
		return false;
	}

}
