package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.PageLoaded;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.component.components.base.BaseProjectComponent;

/***
 * treegrid选择器(左边是treegrid，右边自定义)
 * 
 * @author andy.zhou
 *
 */
public class SelTreeGrid extends BaseProjectComponent{
	
	/****
	 * 组件宽度。<br/>
	 * 类型：整型
	 */
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer width;
	
	/***
	 * 左边树的宽度
	 */
	@Parameter(value="250",defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer widthleft;
	/****
	 * 组件高度。<br/>
	 * 类型：整型
	 */
	@Parameter(value="400",defaultPrefix = BindingConstants.LITERAL)
	@Property
	protected Integer height;
	
	
	
	/****
	 * 列定义
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray columns;
	
	public JSONArray getColumns(){
		if(!resources.isBound("columns")||columns==null||columns.length()==0){
			JSONArray retobj=new JSONArray("[[{field:'text',width:100,title:'text'}]]");
			return retobj;
		}else{
			return columns;
		}
	}
	
	/***
	 * id
	 */
	@Parameter(required = false, value = "id", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String idField;
	/***
	 * text
	 */
	@Parameter(required = false, value = "text", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String treeField;

	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private JSONArray data;
	
	@Parameter(required = false,value="{}",defaultPrefix = BindingConstants.LITERAL)
	private JSONObject params;// 其它附加参数
	
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String dbClickHandle;
	
	public JSONObject getParams(){
		if(!resources.isBound("params")||params==null){
			params=new JSONObject();
		}
		if(resources.isBound("dbClickHandle")){
			params.put("onDblClickRow", dbClickHandle);
		}
		//if(!params.has("onDblClickRow")){
		//	params.put("onDblClickRow", "function(row){require([\"component/rjzjh/seltreegrid\"], function(sel) { sel.dbclickrow('"+getId()+"',row);});}");
		//}
		return params;
	}

	@Inject
	protected ComponentResources resources;
	
/*	@SetupRender
	void addPageEle(MarkupWriter writer) {
		//writer.getDocument().getRootElement().find("body").attribute("class", "easyui-layout");
	}*/
}
