package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.component.tools.ComponentsAssist;

/****
 * 对象框，除style外，其它的非正式参数全部不接收
 * 
 * @author 周俊辉
 * 
 */
@Import(stack = "easyuistack")
public class Dialog extends Window {
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray toolbar;

	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private JSONArray buttons;

	@Override
	protected void writeFieldTag(MarkupWriter writer, final JSONObject spec) {
		packSpec(spec);
		String style = resources.getInformalParameter("style", String.class);
		if (StringUtil.isNull(style)) {
			style = "visibility:hidden;";
		} else {
			if (!style.contains("visibility")) {
				if (style.endsWith(";")) {
					style += "visibility:hidden;";
				} else {
					style += ";visibility:hidden;";
				}
			}
		}
		needInformalParam = false;// 不render非正规则参数
		writer.element("div", "id", getClientId(), "style", style);
		javaScriptSupport.require("init").invoke("dialog").with(spec);
	}

	@AfterRender
	final void afterDialog(MarkupWriter writer) {
		if (resources.isBound("toolbar")) {
			writer.element("div", "id", getClientId() + "_toolbar");
			ComponentsAssist.renderButs(writer, toolbar, null, resources);
			writer.end();
		}
		if (resources.isBound("buttons")) {
			writer.element("div", "id", getClientId() + "_buttons");
			ComponentsAssist.renderButs(writer, buttons, null, resources);
			writer.end();
		}
	}

	@Override
	protected void packSpec(JSONObject spec) {
		super.packSpec(spec);
		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("toolbar"))
			params.put("toolbar", "#" + getClientId() + "_toolbar");

		if (resources.isBound("buttons"))
			params.put("buttons", "#" + getClientId() + "_buttons");

	}

}
