/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.components;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.web.EasyUiAssist;
import net.wicp.tams.commons.web.easyuibean.EasyUINodeConf;
import net.wicp.tams.component.assistbean.Module;
import net.wicp.tams.component.services.ISupportedLocales;
import net.wicp.tams.component.tools.TapestryAssist;
import org.apache.commons.collections.Predicate;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Import(stylesheet={"${path.comassets}/css/layout1.css"}, stack={"easyuistack"})
public class Layout1 {
    private static final Logger log = LoggerFactory.getLogger(Layout1.class);
    @Inject
    private AssetSource assetSource;
    @Inject
    protected Request request;
    @Inject
    protected RequestGlobals requestGlobals;
    @InjectService(value="locales")
    protected ISupportedLocales supportedLocales;
    @Inject
    protected ComponentResources resources;
    @Inject
    @Symbol(value="tapestry.context-path")
    @Property
    protected String contextPath;
    @Inject
    @Symbol(value="path.comassets")
    private String rjzjhpath;
    @Property
    protected String lan;
    @Parameter(defaultPrefix="literal")
    @Property
    private String home;
    @Parameter(defaultPrefix="literal")
    private JSONArray modules;
    @Parameter(defaultPrefix="prop")
    private List<Module> moduleList;
    @Property
    private Module module;
    @Parameter(defaultPrefix="literal")
    private JSONArray dlgs;
    @Property
    private DlgBean dlg;
    @Parameter(defaultPrefix="literal", value="false")
    @Property
    private boolean isLan;
    @Parameter(defaultPrefix="literal")
    private String iconDir;

    public Layout1() {
        this.lan = this.supportedLocales.getCurLocale().getLanguage();
    }

    public List<DlgBean> getDlgList() {
        if (this.dlgs == null || this.dlgs.length() == 0) {
            return CollectionFactory.newList();
        }
        List retlist = JSONObject.parseArray((String)this.dlgs.toString(true), DlgBean.class);
        return retlist;
    }

    public List<Module> getModuleList() {
        if (this.resources.isBound("moduleList")) {
            return this.moduleList;
        }
        if (this.resources.isBound("modules")) {
            List moduleList = JSONObject.parseArray((String)this.modules.toString(true), Module.class);
            return moduleList;
        }
        return CollectionFactory.newList();
    }

    public String getModuleTitle() {
        return this.supportedLocales.getConvert().getStr((Object)(StringUtil.isNull((Object)this.module.getAlt()) ? "\u7f3a\u5c11\u6a21\u5757\u540d" : this.module.getAlt()));
    }

    public Asset getModuleImageB() {
        Asset asset = null;
        try {
            asset = this.assetSource.getExpandedAsset(IOUtil.mergeFolderAndFilePath((String)this.iconDir.replace("|", ":"), (String)this.module.getIconB()));
        }
        catch (Throwable e) {
            asset = this.assetSource.getExpandedAsset(String.format("%s/images/layout1/icons/default_b.png", this.rjzjhpath));
        }
        return asset;
    }

    public Asset getModuleImageW() {
        Asset asset = null;
        try {
            asset = this.assetSource.getExpandedAsset(IOUtil.mergeFolderAndFilePath((String)this.iconDir.replace("|", ":"), (String)this.module.getIconW()));
        }
        catch (Throwable e) {
            asset = this.assetSource.getExpandedAsset(String.format("%s/images/layout1/icons/default_w.png", this.rjzjhpath));
        }
        return asset;
    }

    public Object getSwitchMenuLink() {
        Link link = this.resources.createEventLink("doSwitchmenu", new Object[0]);
        return link.toAbsoluteURI();
    }

    StreamResponse onDoSwitchmenu() {
        final String moduleId = this.request.getParameter("moduleId");
        CaptureResultCallback callback = new CaptureResultCallback();
        this.resources.triggerEvent("switchMenu", new Object[]{moduleId}, (ComponentEventCallback)callback);
        List menus = (List)callback.getResult();
        EasyUINodeConf conf = new EasyUINodeConf("id", "resName", "parentId");
        conf.setAttrCols(new String[]{"resValue", "resType"});
        conf.setIsRoot(new Predicate(){

            public boolean evaluate(Object object) {
                return moduleId.equalsIgnoreCase(String.valueOf(object));
            }
        });
        conf.setTextConvert(this.supportedLocales.getConvert("resName"));
        List retlist = CollectionFactory.newList();
        try {
            retlist = EasyUiAssist.getTreeRoot((List)menus, (EasyUINodeConf)conf);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6a21\u5757\u6811\u9519\u8bef", (Throwable)e);
        }
        String json = EasyUiAssist.getTreeFromList((List)retlist);
        return TapestryAssist.getTextStreamResponse(json);
    }

    public static class DlgBean {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DlgBean)) {
                return false;
            }
            DlgBean other = (DlgBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DlgBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Layout1.DlgBean(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }
}

