package net.wicp.tams.component.components.base;

import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.component.services.ISupportedLocales;

/*****
 * 项目里实现自定义组件可以继承的类
 * 
 * @author 周俊辉
 * 
 */
public class BaseProjectComponent {
	@InjectService("locales")
	protected ISupportedLocales supportedLocales;
	@Inject
	protected JavaScriptSupport support;
	@Inject
	protected ComponentResources resources;
	@Inject
	protected Messages messages;// 国际化

	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String id;
	@Parameter(defaultPrefix = BindingConstants.LITERAL)
	private String name;

	/***
	 * 得到id
	 * 
	 * @return
	 */
	public String getId() {
		if (StringUtils.isBlank(this.id) && !resources.isBound("id")) {
			this.id = support.allocateClientId(resources);
		}
		return this.id;
	}

	/****
	 * 得到name属性
	 * 
	 * @return
	 */
	public String getName() {
		if (!resources.isBound("name")) {
			return getId();
		} else {
			return this.name;
		}
	}

	/****
	 * 得到语言环境
	 * 
	 * @return
	 */
	public String getLan() {
		return supportedLocales.getCurLocale().getLanguage();
	}

	/***
	 * 国际化转换器
	 * 
	 * @return
	 */
	protected final IConvertValue<String> getI18Convert() {
		return supportedLocales.getConvert();
	}
}
