/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.stack;

import java.util.Collections;
import java.util.List;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.component.constant.EasyUIStyle;
import net.wicp.tams.component.services.ISupportedLocales;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.javascript.JavaScriptAggregationStrategy;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StylesheetLink;

public class EasyUIStack
implements JavaScriptStack {
    private final Mapper<String, StylesheetLink> pathToStyles;
    private final Mapper<String, Asset> pathToAsset;
    private final ISupportedLocales supportedLocales;
    private final RequestGlobals requestGlobals;

    public EasyUIStack(final AssetSource assetSource, final @Symbol(value="path.easyui") String easyuipath, ISupportedLocales supportedLocales, RequestGlobals requestGlobals) {
        this.supportedLocales = supportedLocales;
        this.requestGlobals = requestGlobals;
        this.pathToStyles = new Mapper<String, StylesheetLink>(){

            public StylesheetLink map(String path) {
                return new StylesheetLink(assetSource.getClasspathAsset(easyuipath + path));
            }
        };
        this.pathToAsset = new Mapper<String, Asset>(){

            public Asset map(String path) {
                return assetSource.getExpandedAsset(easyuipath + path);
            }
        };
    }

    public List<Asset> getJavaScriptLibraries() {
        String addStr = "zh";
        addStr = "zh".equals(this.supportedLocales.getCurLocale().getLanguage()) ? "zh_CN" : this.supportedLocales.getCurLocale().getLanguage();
        String langUrl = String.format("/locale/easyui-lang-%s.js", addStr);
        return F.flow((Object[])new String[]{"/jquery.easyui.min.js", langUrl}).map(this.pathToAsset).toList();
    }

    public List<StylesheetLink> getStylesheets() {
        EasyUIStyle themeValue = EasyUIStyle.defaultSty;
        Object[] cookies = this.requestGlobals.getHTTPServletRequest().getCookies();
        if (ArrayUtils.isNotEmpty((Object[])cookies)) {
            for (Object cookie : cookies) {
                if (!"easyui.default.theme.cookiename".equals(cookie.getName()) || !StringUtil.isNotNull((Object)cookie.getValue())) continue;
                themeValue = EasyUIStyle.valueOfDefault(cookie.getValue(), EasyUIStyle.defaultSty);
                break;
            }
        }
        return F.flow((Object[])new String[]{String.format("/themes/%s/easyui.css", themeValue.getValue()), "/themes/icon.css"}).map(this.pathToStyles).toList();
    }

    public List<String> getStacks() {
        return Collections.emptyList();
    }

    public List<String> getModules() {
        return Collections.emptyList();
    }

    public JavaScriptAggregationStrategy getJavaScriptAggregationStrategy() {
        return JavaScriptAggregationStrategy.DO_NOTHING;
    }

    public String getInitialization() {
        return null;
    }
}

