/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.components;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import net.wicp.tams.commons.apiext.JSONUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.commons.callback.impl.convertvalue.ConvertValueEnum;
import net.wicp.tams.component.components.ComboBox;
import net.wicp.tams.component.services.ISupportedLocales;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.json.JSONArray;

public class ComboBoxEnum
extends ComboBox {
    @Parameter(required=true, defaultPrefix="literal")
    private String enumClass;
    @Parameter(required=false, defaultPrefix="literal")
    private String include;
    @Parameter(required=false, defaultPrefix="literal")
    private String remove;
    @Inject
    private ISupportedLocales locale;

    @SetupRender
    private void init() throws ClassNotFoundException {
        this.resources.storeRenderVariable("valueField", (Object)"name");
        this.resources.storeRenderVariable("textField", (Object)"text");
        Class<?> cls = Class.forName(this.enumClass);
        Object[] objs = cls.getEnumConstants();
        if (ArrayUtils.isEmpty((Object[])objs)) {
            super.setData(new JSONArray("[]"));
        } else {
            String lan;
            List list = Arrays.asList(objs);
            if (this.resources.isBound("include") && StringUtil.isNotNull((Object)this.include)) {
                final String[] ins = this.include.split(",");
                list = (List)CollectionUtils.select(list, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        Enum temobj = (Enum)object;
                        return ArrayUtils.contains((Object[])ins, (Object)temobj.name());
                    }
                });
            }
            if (this.resources.isBound("remove") && StringUtil.isNotNull((Object)this.remove)) {
                final String[] outs = this.remove.split(",");
                CollectionUtils.filter((Collection)list, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        Enum temobj = (Enum)object;
                        return !ArrayUtils.contains((Object[])outs, (Object)temobj.name());
                    }
                });
            }
            String filedName = StringUtil.isNull((Object)(lan = this.locale.getCurLocale().getLanguage())) ? "desc" : String.format("desc_%s", lan);
            ConvertValueEnum cv = new ConvertValueEnum(list.toArray(), lan);
            String curData = JSONUtil.getJsonForList((List)list, (IConvertValue[])new IConvertValue[]{null, cv}, (String[])new String[]{"name,", filedName + ",text"});
            super.setData(new JSONArray(curData));
        }
    }
}

