/*******************************************************************************
 * 通过这种方式可以达到即使同一页面有很多组件也只执行一次
 */
define(["jquery","core"], function($,core) {
	$(function() {
		$('.drag').each(function() {
			var datastr = $(this).attr('data-options');
			if (datastr) {
				var data = $.parseJSON(datastr);
				var tempId='template-'+$(this).attr('id').replace('-'+data.id,'');//得到模板的ID
				$(this).bindTemplate({
					source : data,
					template : $("#"+tempId)
				});
			}
			$(this).draggable({
				proxy : 'clone',
				revert : true,
				cursor : 'auto',
				onStartDrag : function() {
					$(this).draggable('options').cursor = 'not-allowed';
					$(this).draggable('proxy').addClass('dp');
				},
				onStopDrag : function() {
					$(this).draggable('options').cursor = 'auto';
				}
			});
		});
	});
	_droppable=function(id,acceptstr){
		 $('#'+id).droppable({
			 accept:acceptstr,
             onDragEnter:function(e,source){
                  $(source).draggable('options').cursor='auto';
                  $(source).draggable('proxy').css('border','1px solid red');
                  $(this).addClass('over');
              },
              onDragLeave:function(e,source){
                  $(source).draggable('options').cursor='not-allowed';
                  $(source).draggable('proxy').css('border','1px solid #ccc');
                  $(this).removeClass('over');
              },
              onDrop:function(e,source){
                  $(this).append(source)
                  $(this).removeClass('over');
                  _dragDiv(id,source);
              }
       });
	};
	_dragDiv=function(targetId,source){//如果拖动div停止后触发的,targetId 拖动后div所在区域的Id,source 拖动的Div
		var field=targetId.replace('source_','').replace('target_','');
		
		var valuestr=$('#'+field).val();
		var valueary = $.parseJSON(valuestr);
		
		var datastr=$('#'+source.id).attr('data-options');
		var data = $.parseJSON(datastr);
		var index=$.inArray(data.id, valueary);//拖动的元素ID在hidden值中的位置
		
		if(targetId.indexOf("source_")===0){//拖到的select列的框中,要加
			if(index<0){
				valueary.push(data.id);
			}
		}else if(targetId.indexOf("target_")===0){ //拖到的unselect列的框中,要减
			if(index>=0){
				valueary.splice(index,1);
			}
		}
		valueary.sort();
		$('#'+field).val(JSON.stringify(valueary));
	};
	_selectall=function(id){
		var targetId='target_'+id;
		var sourceId='source_'+id;
		$('#'+targetId+'>div[id^="'+id+'"]').each(function(){
			_dragDiv(sourceId,$(this)[0]);
			$('#'+sourceId).append($(this));
			//$(this).remove();//它会把添加成功的删除掉
			
		});
	};
	_removeall=function(id){
		var targetId='target_'+id;
		var sourceId='source_'+id;
		$('#'+sourceId+'>div[id^="'+id+'"]').each(function(){
			_dragDiv(targetId,$(this)[0]);
			$('#'+targetId).append($(this));
			//$(this).remove();//它会把添加成功的删除掉
			
		});
	};
	_save=function(url,id,sucHandle,checkHandle,packHandle){//保存选择的值
		//var ids=$('#'+id).val(); // (为什么会取错值?补救,重新计算一下ids值)
		if(checkHandle &&!checkHandle()){
			return false;
		}
		var sourceId='source_'+id;
		var ids=[];
		$('#'+'source_'+id+'>div[id^="'+id+'"]').each(function(){
			var datastr=$(this).attr('data-options');
			var data = $.parseJSON(datastr);
			ids.push(data.id);
		});
		ids.sort();
		ids=JSON.stringify(ids);
		var params={};
		if(packHandle){
			params=packHandle();
		}
		$.post(url,{'ids':ids,'params':JSON.stringify(params)},function(data){
			core.opt2(data,function(){
				if(sucHandle!=null){
					sucHandle();
				}else{
					core.alert(data.msg);
				}
			});
			$.messager.progress('close');
		},'json');		
	};
	_clear=function(id){//清除所有可拖动项
	   var targetId='target_'+id;
	   var sourceId='source_'+id;
	   $('#'+sourceId+'>div[id^="'+id+'"]').each(function(){
			$(this).remove();
	   });
	   $('#'+targetId+'>div[id^="'+id+'"]').each(function(){
			$(this).remove();
	   });
	   $('#'+id).val('[]');//清除已选择项
	};
	_add=function(id,data,issel){//添加一个拖动项
	   var targetId='target_'+id;
	   var sourceId='source_'+id;
	   var parentId=targetId;
	   if(issel){
	      parentId=sourceId;
	   }
	   var idstr=id+'-'+data.id;//JSON.stringify(data)
	   $("#"+parentId).append('<div id="'+idstr+'" class="drag"></div>');
	   $('#'+idstr).attr('data-options',JSON.stringify(data));
	   
	   var tempId='template-'+id;//得到模板的ID
	   $('#'+idstr).bindTemplate({
			source : data,
			template : $("#"+tempId)
	   });
	   $('#'+idstr).draggable({
				proxy : 'clone',
				revert : true,
				cursor : 'auto',
				onStartDrag : function() {
					$(this).draggable('options').cursor = 'not-allowed';
					$(this).draggable('proxy').addClass('dp');
				},
				onStopDrag : function() {
					$(this).draggable('options').cursor = 'auto';
				}
	  });
	};
	_init2=function(id,datas,selIds){//初始化一个selgroup
	   _clear(id);
	   $.each(datas,function(i,n){
	      var idIndex=$.inArray(n.id,selIds);
	      var issel= idIndex===-1?0:1;
	      _add(id,n,issel);
	   });
	};
	_init=function(id,initDate){//初始化一个selgroup,initDate是一个json对象,拥有"data"和"sel"域
		_init2(id,initDate.data,initDate.sel);
	}
	_get=function(id){//初始化一个selgroup,initDate是一个json对象,拥有"data"和"sel"域
		return $('#selgroup_'+id);
	}
	
	return {droppable:_droppable,selectall:_selectall,removeall:_removeall,save:_save,clear:_clear,add:_add,init:_init,init2:_init2,get:_get};
});
