/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.components.base;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.component.components.base.AbstractExtendableComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

public abstract class BaseValidateBox
extends AbstractExtendableComponent {
    @Parameter(required=false, defaultPrefix="literal")
    private boolean required;
    @Parameter(required=false, defaultPrefix="literal")
    private JSONArray validType;
    @Parameter(required=false, defaultPrefix="message")
    private String missingMessage;
    @Inject
    @Symbol(value="input.width")
    private int inputWidth;
    @Parameter(required=false, defaultPrefix="message")
    private String invalidMessage;

    @Override
    protected void writeFieldTag(MarkupWriter writer, JSONObject spec) {
        this.packParms(spec);
        Element element = writer.element("input", new Object[]{"id", this.getClientId()});
        if (spec.has("parent")) {
            element.attribute("url", spec.getJSONObject("params").getString("url"));
            element.attribute("parent", spec.getString("parent"));
        }
        if (this.resources.isBound("value")) {
            element.attribute("value", String.valueOf(this.value));
        }
        String componentsClass = spec.getString("class");
        boolean ishtml = spec.has("ishtml") ? spec.getBoolean("ishtml") : false;
        spec.remove("class");
        spec.remove("ishtml");
        if (StringUtils.isEmpty((String)componentsClass)) {
            return;
        }
        if (ishtml) {
            element.attribute("class", "easyui-" + componentsClass);
            element.attribute("data-options", spec.getJSONObject("params").toString());
        } else {
            this.javaScriptSupport.require("init").invoke(componentsClass).with(new Object[]{spec});
        }
    }

    @AfterRender
    protected final void afterRender(MarkupWriter writer) {
        Element element = writer.getElement();
        String style = element.getAttribute("style");
        String widthStr = "width:" + this.inputWidth + "px";
        if (StringUtil.isNotNull((Object)style)) {
            if (style.indexOf("width") < 0) {
                style = style.charAt(style.length() - 1) == ';' ? style + widthStr : style + ";" + widthStr;
            }
        } else {
            style = widthStr;
        }
        element.forceAttributes(new String[]{"style", style});
        writer.end();
    }

    protected void packParms(JSONObject spec) {
        JSONObject params = spec.getJSONObject("params");
        if (this.resources.isBound("required")) {
            params.put("required", (Object)this.required);
        }
        if (this.resources.isBound("validType")) {
            params.put("validType", (Object)this.validType);
        }
        if (this.resources.isBound("missingMessage")) {
            params.put("missingMessage", (Object)this.missingMessage);
        }
        if (this.resources.isBound("invalidMessage")) {
            params.put("invalidMessage", (Object)this.invalidMessage);
        }
    }
}

