/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.components;

import java.math.BigDecimal;
import java.util.List;
import net.wicp.tams.component.assistbean.HighchartsBean;
import net.wicp.tams.component.constant.ChartType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;

public class Highcharts {
    @Inject
    protected ComponentResources resources;
    @Inject
    protected Messages messages;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    @Property
    private String id;
    @Inject
    @Symbol(value="tapestry.context-path")
    @Property(write=false)
    private String contextPath;
    @Parameter(required=false, value="line", defaultPrefix="literal")
    @Property
    private ChartType chartType;
    @Parameter(required=true, defaultPrefix="message")
    @Property
    private String title;
    @Parameter(required=false, defaultPrefix="literal")
    @Property
    private String exportHandle;
    @Parameter(required=false, value="true", defaultPrefix="literal")
    @Property
    private boolean tooltipShared;
    @Parameter(required=false, defaultPrefix="literal")
    @Property
    private JSONObject initParam;
    @Parameter(required=false, defaultPrefix="message")
    @Property
    private String xTitle;
    @Parameter(required=true, defaultPrefix="message")
    @Property
    private JSONArray xAry;
    @Parameter(required=false, defaultPrefix="message")
    @Property
    private String yTitle;
    @Parameter(required=false, defaultPrefix="message")
    @Property
    private String tooltip;
    @Property
    private List<HighchartsBean> showDatas;
    @Component(id="highcharts")
    private Zone chatZone;
    @Inject
    private Request request;

    public JSONArray getSeries() {
        JSONArray retObj = new JSONArray();
        if (CollectionUtils.isEmpty(this.showDatas)) {
            return retObj;
        }
        for (HighchartsBean ele : this.showDatas) {
            JSONObject elejson = new JSONObject(new Object[]{"name", ele.getName()});
            JSONArray values = new JSONArray();
            for (int i = 0; i < this.xAry.length(); ++i) {
                Object temp = ele.getValue(i);
                if (temp == null) {
                    values.put(i, (Object)0);
                    continue;
                }
                if (temp instanceof Integer) {
                    values.put(i, (Object)((Integer)temp));
                    continue;
                }
                if (temp instanceof Double) {
                    values.put(i, (Object)((Double)temp));
                    continue;
                }
                if (!(temp instanceof BigDecimal)) continue;
                values.put(i, (Object)((BigDecimal)temp));
            }
            elejson.put("data", (Object)values);
            retObj.put((Object)elejson);
        }
        return retObj;
    }

    Block onActionFromHighchartsUpdate() {
        JSONObject parm = new JSONObject();
        List keys = this.request.getParameterNames();
        for (String key : keys) {
            parm.put(key, (Object)this.request.getParameter(key));
        }
        this.queryCharts(parm);
        return this.chatZone.getBody();
    }

    private void queryCharts(JSONObject param) {
        CaptureResultCallback callback = new CaptureResultCallback();
        if (param != null && param.has("t:zoneid")) {
            param.remove("t:zoneid");
        }
        this.resources.triggerEvent("query", new Object[]{param}, (ComponentEventCallback)callback);
        if (callback.getResult() != null) {
            this.showDatas = (List)callback.getResult();
        }
    }

    @BeforeRenderTemplate
    private void initRecord() {
        this.queryCharts(this.resources.isBound("initParam") ? this.initParam : new JSONObject());
    }
}

