package net.wicp.tams.component.assistbean;

import java.util.ArrayList;
import java.util.List;

/***
 * Highcharts报表辅助类
 * 
 * @author Administrator
 * 
 */
public class HighchartsBean<T> {
	private final String name;

	public HighchartsBean(String name) {
		this.name = name;
	}

	public final List<T> values = new ArrayList<T>();
	
	public void putValue(T value){
		values.add(value);
	}

	public String getName() {
		return this.name;
	}

	public T getValue(int index) {
		return values.size() > index ? values.get(index) : null;
	}
}
