/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.services.impl;

import java.util.Locale;
import java.util.Map;
import net.wicp.tams.commons.apiext.ReflectAssist;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.component.services.ISupportedLocales;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.PersistentLocale;

public class SupportedLocalesImpl
implements ISupportedLocales {
    private String supportedLocales;
    @Inject
    private PersistentLocale persistentLocale;
    @Inject
    @Symbol(value="tapestry.context-path")
    private String contextPath;
    @Inject
    private Messages messages;
    private final IConvertValue<String> I18NConvert = new IConvertValue<String>(){

        public String getStr(String key) {
            if (StringUtil.isNull((Object)key) || !SupportedLocalesImpl.this.messages.contains(key)) {
                return key;
            }
            return SupportedLocalesImpl.this.messages.get(key);
        }
    };

    public SupportedLocalesImpl(@Inject @Symbol(value="tapestry.supported-locales") String locales) {
        this.supportedLocales = locales;
    }

    @Override
    public String getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public void setLocale(String lang) {
        Locale local = new Locale(lang);
        this.persistentLocale.set(local);
    }

    @Override
    public Locale getCurLocale() {
        if (this.persistentLocale.get() == null) {
            this.persistentLocale.set(Locale.CHINESE);
        }
        return this.persistentLocale.get();
    }

    @Override
    public String buildUrl(String oriUrl) {
        String startStr = this.contextPath + "/" + this.getCurLocale().getLanguage();
        if (StringUtil.isNull((Object)oriUrl) || StringUtils.isNotBlank((CharSequence)this.contextPath) && oriUrl.startsWith("/" + this.contextPath) || oriUrl.startsWith(startStr)) {
            return oriUrl;
        }
        String lanString = "/" + this.getCurLocale().getLanguage();
        if (oriUrl.startsWith("nolan:")) {
            lanString = "";
            oriUrl = oriUrl.replace("nolan:", "");
        }
        if (oriUrl.startsWith("/")) {
            return this.contextPath + lanString + oriUrl;
        }
        return this.contextPath + lanString + "/" + oriUrl;
    }

    @Override
    public IConvertValue<String> getConvert() {
        return this.I18NConvert;
    }

    @Override
    public IConvertValue<Object> getConvert(final String colName) {
        return new IConvertValue<Object>(){

            public String getStr(Object obj) {
                if (obj == null) {
                    return "";
                }
                String key = "";
                try {
                    key = ReflectAssist.isInterface(obj.getClass(), (String)"java.util.Map") ? String.valueOf(((Map)obj).get(colName)) : BeanUtils.getSimpleProperty((Object)obj, (String)colName);
                    if (SupportedLocalesImpl.this.messages.contains(key)) {
                        return SupportedLocalesImpl.this.messages.get(key);
                    }
                    return key;
                }
                catch (Exception e) {
                    return key;
                }
            }
        };
    }
}

