/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.component.services.impl;

import java.util.Locale;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.component.services.ISupportedLocales;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.PersistentLocale;

public class SupportedLocalesImpl
implements ISupportedLocales {
    private String supportedLocales;
    @Inject
    private PersistentLocale persistentLocale;
    @Inject
    @Symbol(value="tapestry.context-path")
    private String contextPath;

    public SupportedLocalesImpl(@Inject @Symbol(value="tapestry.supported-locales") String locales) {
        this.supportedLocales = locales;
    }

    @Override
    public String getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public void setLocale(String lang) {
        Locale local = new Locale(lang);
        this.persistentLocale.set(local);
    }

    @Override
    public Locale getCurLocale() {
        if (this.persistentLocale.get() == null) {
            this.persistentLocale.set(Locale.CHINESE);
        }
        return this.persistentLocale.get();
    }

    @Override
    public String buildUrl(String oriUrl) {
        String startStr = this.contextPath + "/" + this.getCurLocale().getLanguage();
        if (StringUtil.isNull((Object)oriUrl) || StringUtils.isNotBlank((CharSequence)this.contextPath) && oriUrl.startsWith("/" + this.contextPath) || oriUrl.startsWith(startStr)) {
            return oriUrl;
        }
        String lanString = "/" + this.getCurLocale().getLanguage();
        if (oriUrl.startsWith("nolan:")) {
            lanString = "";
            oriUrl = oriUrl.replace("nolan:", "");
        }
        if (oriUrl.startsWith("/")) {
            return this.contextPath + lanString + oriUrl;
        }
        return this.contextPath + lanString + "/" + oriUrl;
    }
}

