package net.wicp.tams.component.tools;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ArrayUtils;

import net.wicp.tams.commons.constant.DateFormatCase;
import net.wicp.tams.component.assistbean.HighchartsBean;

public class HighchartsUtil {
	/***
	 * 创建报表用的横坐标标题
	 * 
	 * @param begin
	 *            开始时间
	 * @param end
	 *            结束时间
	 * @return
	 */
	public static String createTitle(Date begin, Date end) {
		StringBuffer buff = new StringBuffer("[");
		Calendar ca = Calendar.getInstance();
		while (end.compareTo(begin) >= 0) {
			buff.append("'"
					+ DateFormatCase.YYYY_MM_DD.getInstanc()
							.format(begin) + "',");
			ca.setTime(begin);
			ca.add(Calendar.DATE, 1);
			begin = ca.getTime();
		}
		buff.delete(buff.length() - 1, buff.length());
		buff.append("]");
		return buff.toString();
	}

	/***
	 * 新建容器集合
	 * @param items
	 * @return
	 */
	public static List<HighchartsBean<Integer>> newHighchartsSeries(
			String... items) {
		List<HighchartsBean<Integer>> retObj = new ArrayList<HighchartsBean<Integer>>();
		if (ArrayUtils.isEmpty(items)) {
			return retObj;
		}
		for (String item : items) {
			HighchartsBean<Integer> temp = new HighchartsBean<Integer>(item);
			retObj.add(temp);
		}
		return retObj;
	}

	public static List<HighchartsBean<Double>> newHighchartsSeriesD(
			String... items) {
		List<HighchartsBean<Double>> retObj = new ArrayList<HighchartsBean<Double>>();
		if (ArrayUtils.isEmpty(items)) {
			return retObj;
		}
		for (String item : items) {
			HighchartsBean<Double> temp = new HighchartsBean<Double>(item);
			retObj.add(temp);
		}
		return retObj;
	}
	
	public static List<HighchartsBean<BigDecimal>> newHighchartsSeriesB(
			String... items) {
		List<HighchartsBean<BigDecimal>> retObj = new ArrayList<HighchartsBean<BigDecimal>>();
		if (ArrayUtils.isEmpty(items)) {
			return retObj;
		}
		for (String item : items) {
			HighchartsBean<BigDecimal> temp = new HighchartsBean<BigDecimal>(item);
			retObj.add(temp);
		}
		return retObj;
	}

}
