package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;

@Import(stack = "easyuistack")
public class Window extends Panel {
	/**
	 * 是否关闭此窗口
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean closed;

	/**
	 * 窗口显示的层级
	 */
	@Parameter(required = false, value = "9000", defaultPrefix = BindingConstants.LITERAL)
	private int zIndex;

	/**
	 * 是否可以拖曳
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean draggable;

	/**
	 * 是否可以缩放
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean resizable;

	/**
	 * 是否显示阴影
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean shadow;

	/**
	 * 是否内联摆放窗口，true：嵌入到父容器的内部 false:放到所有元素顶部
	 */
	@Parameter(required = false, value = "false", defaultPrefix = BindingConstants.LITERAL)
	private boolean inline;

	/**
	 * 是否模态窗口
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean modal;
	
	@Override
	protected void writeFieldTag(MarkupWriter writer,final JSONObject spec) {
		packSpec(spec);
		writer.element("div", "id", getClientId(), "class", "easyui-window",
				"data-options", spec.getJSONObject("params"));
	}

	@Override
	protected void packSpec(JSONObject spec) {
		super.packSpec(spec);
		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("closed"))
			params.put("closed", closed);

		if (resources.isBound("zIndex"))
			params.put("zIndex", zIndex);
		if (resources.isBound("draggable"))
			params.put("draggable", draggable);
		if (resources.isBound("resizable"))
			params.put("resizable", resizable);
		if (resources.isBound("shadow"))
			params.put("shadow", shadow);
		if (resources.isBound("inline"))
			params.put("inline", inline);
		if (resources.isBound("modal"))
			params.put("modal", modal);
	}

}
