package net.wicp.tams.component.components;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;

/****
 * 微调数字框
 * 
 * @author 周俊辉
 * 
 */
@Import(stack = "easyuistack")
public class NumberSpinner extends NumberBox {

	/***
	 * 组件宽度
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int width;

	/***
	 * 组件高度
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int height;

	/***
	 * 增长单位
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private int increment;

	/***
	 * 是否可能直接输入值修改,默认为可以
	 */
	@Parameter(required = false, value = "true", defaultPrefix = BindingConstants.LITERAL)
	private boolean editable;
	/***
	 * 当点击向上或向下时触发的函数：function(down)
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	private String spin;

	@Override
	protected void packParms(JSONObject spec) {
		super.packParms(spec);
		spec.put("class", "numberspinner");
		spec.put("ishtml", false);

		JSONObject params = spec.getJSONObject("params");
		if (resources.isBound("width"))
			params.put("width", width);
		if (resources.isBound("height"))
			params.put("height", height);

		if (resources.isBound("increment"))
			params.put("increment", increment);
		if (resources.isBound("editable"))
			params.put("editable", editable);
		if (resources.isBound("spin"))
			spec.put("spin", spin);
	}

	boolean beforeRenderBody() {
		return false;
	}

}
