package net.wicp.tams.component.components;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;

import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.assistbean.HighchartsBean;
import net.wicp.tams.component.constant.ChartType;

/*****
 * 报表Highcharts组件
 * 
 * @author Administrator
 * 
 */
@Events({ SymbolConstantsCus.EVENT_QUERY })
public class Highcharts {
	@Inject
	protected ComponentResources resources;
	
	@Inject
	protected Messages messages;// 国际化

	@Parameter(value = "prop:componentResources.id", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String id;
	
	@Inject
	@Symbol(SymbolConstants.CONTEXT_PATH) 
	@Property(write=false)
	private String contextPath;
	
	/****
	 * 报表类型　column：柱状图
	 */
	@Parameter(required = false, value="line", defaultPrefix = BindingConstants.LITERAL)
	@Property
	private ChartType chartType;

	/****
	 * 标题
	 */
	@Parameter(required = true, defaultPrefix = BindingConstants.MESSAGE)
	@Property
	private String title;
	
	/****
	 *自定义导出Excel要执行的方法
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private String exportHandle;
	
	/****
	 * 是否共享，默认为共享
	 */
	@Parameter(required = false,value="true",defaultPrefix = BindingConstants.LITERAL)
	@Property
	private boolean  tooltipShared;
	
	/****
	 * 需要传入的标识参数（它会传给查询条件）
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
	@Property
	private JSONObject initParam;

	/****
	 * 横坐标上的标题
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.MESSAGE)
	@Property
	private String xTitle;
	/****
	 * Ｘ轴需要显示的数据
	 */
	@Parameter(required = true, defaultPrefix = BindingConstants.MESSAGE)
	@Property
	private JSONArray xAry;

	/****
	 * 纵坐标上的标题
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.MESSAGE)
	@Property
	private String yTitle;

	/****
	 * 提示用的标题
	 */
	@Parameter(required = false, defaultPrefix = BindingConstants.MESSAGE)
	@Property
	private String tooltip;

	@Property
	private List<HighchartsBean> showDatas;

	public JSONArray getSeries() {
		JSONArray retObj = new JSONArray();
		if (CollectionUtils.isEmpty(showDatas)) {
			return retObj;
		}
		for (HighchartsBean ele : showDatas) {
			JSONObject elejson = new JSONObject("name", ele.getName());
			JSONArray values = new JSONArray();
			for (int i = 0; i < xAry.length(); i++) {
				Object temp=ele.getValue(i);
				if(temp==null){
					values.put(i,0);
				}else if(temp instanceof Integer){
					values.put(i, (Integer)temp);
				}else if(temp instanceof Double){
					values.put(i, (Double)temp);
				}else if(temp instanceof BigDecimal){
					values.put(i, (BigDecimal)temp);
				}else{
					continue;//非整形和Double型放弃
				}
			}
			elejson.put("data", values);
			retObj.put(elejson);
		}
		return retObj;
	}

	@Component(id = "highcharts")
	private Zone chatZone;
	
	@Inject
	private Request request;

	Block onActionFromHighchartsUpdate() {
		JSONObject parm=new JSONObject();
		List<String> keys=request.getParameterNames();
		for (String key : keys) {
			parm.put(key, request.getParameter(key));
		}
		queryCharts(parm);
		return chatZone.getBody();
	}

	private void queryCharts(JSONObject param) {
		CaptureResultCallback<List<HighchartsBean>> callback = new CaptureResultCallback<List<HighchartsBean>>();
		if(param!=null&&param.has("t:zoneid")){
			param.remove("t:zoneid");
		}		
		resources.triggerEvent(SymbolConstantsCus.EVENT_QUERY, new Object[]{param}, callback);
		if (callback.getResult() != null) {
			showDatas = callback.getResult();
		}
	}
	
	@BeforeRenderTemplate
	private void initRecord() {
		queryCharts(resources.isBound("initParam")?initParam:new JSONObject());
	}

}
