package net.wicp.tams.component.tools.convert;

import org.apache.tapestry5.ioc.Messages;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;

/*****
 * 枚举类型的国际化转换类
 * 
 * @author Administrator
 * 
 * @param <T>
 */
public class ConvertValueEnum implements IConvertValue<String> {
	private final Class entityClass;
	private final Messages messages;

	public ConvertValueEnum(Class entityClass, Messages messages) {
		this.entityClass = entityClass;
		this.messages = messages;
	}

	@Override
	public String getStr(String key) {
		if(StringUtil.isNull(key)) return "";
		String keytrue = entityClass.getName() + "." + key;
		String retstr=messages.contains(keytrue)?messages.get(keytrue):key;
		return retstr;
	}

}
