package net.wicp.tams.component.services.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.component.SymbolConstantsCus;
import net.wicp.tams.component.components.Upload;
import net.wicp.tams.component.services.ITools;

public class ToolsImpl implements ITools {

	@Inject
	private MultipartDecoder decoder;

	@Inject
	private ServletContext servletContext;
	@Inject
	private Request request;
	@Inject
	@Symbol(SymbolConstantsCus.PATH_FILE_UPLOAD_DIR)
	private String defaultUploadDir;// 默认的文件上传目录,在service里配置

	@Inject
	@Symbol(SymbolConstants.CONTEXT_PATH)
	private String contextPath;// 默认的文件上传目录,在service里配置c

	private static String contextfilepath = null;
	private static File contextfileDir = null;
	private static File uploadDir = null;// 默认的文件上传目录　

	@Override
	public List<File> saveUpload(File uploadDirParam) {
		File uploadDirTrue = (uploadDirParam == null || !uploadDirParam
				.exists()) ? getUploadDir() : uploadDirParam;
		List<File> retList = new ArrayList<File>();
		List<String> params = request.getParameterNames();
		for (String param : params) {
			if (param.startsWith(Upload.prefix)) {// 上传文件域
				UploadedFile uploadedFile = decoder.getFileUpload(param);
				System.out.println(uploadedFile.getFileName());
				// String exportFileName = Integer.toString(Math.abs(new
				// Random().nextInt()));
				File copied = new File(uploadDirTrue,
						uploadedFile.getFileName());// 文件名　agentid_随机数_fileName
				uploadedFile.write(copied);
				retList.add(copied);
			}
		}
		return retList;
	}

	@Override
	public List<File> saveUpload() {
		return saveUpload(null);
	}

	@Override
	public List<File> saveUploadContext(String uploadPathFromContext) {
		File toDir = StringUtil.isNull(uploadPathFromContext) ? contextfileDir
				: new File(contextfilepath, uploadPathFromContext);
		if (!toDir.exists()) {
			toDir.mkdir();
		}
		return saveUpload(toDir);
	}

	@Override
	public String getContextFilePath() {
		if (contextfilepath == null) {
			contextfilepath = servletContext.getRealPath("/");
		}
		return contextfilepath;
	}

	@Override
	public File getContextDir() {
		if (contextfileDir == null) {
			contextfileDir = new File(getContextFilePath());
			if (!contextfileDir.exists()) {
				contextfileDir.mkdir();
			}
		}
		return contextfileDir;
	}

	@Override
	public File getUploadDir() {
		String uploadDirPath = getContextFilePath() + File.separator
				+ defaultUploadDir;
		if (uploadDir == null) {
			uploadDir = new File(uploadDirPath);
			if (!uploadDir.exists()) {
				uploadDir.mkdir();
			}
		}
		return uploadDir;
	}

}
