package net.wicp.tams.component.services;

import java.io.File;
import java.util.List;

public interface ITools {
	/***
	 * 文件上传工具方法
	 * 
	 * @param uploadDir
	 *            上传的文件路径
	 * @return
	 */
	public List<File> saveUpload(File uploadDirParam);

	/***
	 * 文件上传工具方法
	 * 
	 * @param uploadDirPath
	 *            相对于context文件夹路径
	 * @return
	 */
	public List<File> saveUploadContext(String uploadPathFromContext);

	/***
	 * 文件上传工具方法：上传到默认的文件路径
	 * 
	 * @return
	 */
	public List<File> saveUpload();

	/****
	 * 得到context的文件路径
	 * 
	 * @return
	 */
	public String getContextFilePath();

	/****
	 * 得到context的文件目录　
	 * 
	 * @return
	 */
	public File getContextDir();

	/***
	 * 得到默认的文件上传目录
	 * 
	 * @return
	 */
	public File getUploadDir();
}
